package in.sunilpaulmathew.izzyondroid.adapters;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.textview.MaterialTextView;

import java.util.List;

import in.sunilpaulmathew.izzyondroid.R;
import in.sunilpaulmathew.izzyondroid.utils.AppSettings;
import in.sunilpaulmathew.izzyondroid.utils.Common;
import in.sunilpaulmathew.izzyondroid.utils.PackageData;
import in.sunilpaulmathew.sCommon.CommonUtils.sCommonUtils;
import in.sunilpaulmathew.sCommon.CommonUtils.sExecutor;
import in.sunilpaulmathew.sCommon.CommonUtils.sSerializableItems;
import in.sunilpaulmathew.sCommon.Dialog.sSingleChoiceDialog;
import in.sunilpaulmathew.sCommon.ThemeUtils.sThemeUtils;
import in.sunilpaulmathew.sCommon.TranslatorUtils.sTranslatorUtils;

/*
 * Created by sunilpaulmathew <sunil.kde@gmail.com> on August 19, 2021
 */
public class SettingsAdapter extends RecyclerView.Adapter<SettingsAdapter.ViewHolder> {

    private static List<sSerializableItems> data;

    public SettingsAdapter(List<sSerializableItems> data){
        SettingsAdapter.data = data;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View rowItem = LayoutInflater.from(parent.getContext()).inflate(R.layout.rv_searching, parent, false);
        return new ViewHolder(rowItem);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        try {
            holder.mName.setText(data.get(position).getTextOne());
            holder.mSummary.setText(data.get(position).getTextTwo());
            holder.mIcon.setImageDrawable(data.get(position).getIcon());
            AppSettings.setSlideInAnimation(holder.mName, position);
        } catch (IndexOutOfBoundsException | NullPointerException ignored) {}
    }

    @Override
    public int getItemCount() {
        return data.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder implements View.OnClickListener {
        private final AppCompatImageView mIcon;
        private final MaterialTextView mName, mSummary;
        private final ProgressBar mProgress;

        public ViewHolder(View view) {
            super(view);
            view.setOnClickListener(this);
            this.mIcon = view.findViewById(R.id.icon);
            this.mName = view.findViewById(R.id.title);
            this.mSummary = view.findViewById(R.id.description);
            this.mProgress = view.findViewById(R.id.progress);
        }

        @Override
        public void onClick(View view) {
            if (data.get(getBindingAdapterPosition()).getTextThree() != null) {
                sCommonUtils.launchUrl(data.get(getBindingAdapterPosition()).getTextThree(), (Activity) view.getContext());
                return;
            }
            switch (getBindingAdapterPosition()) {
                case 0:
                    new sSingleChoiceDialog(R.drawable.ic_theme, view.getContext().getString(R.string.app_theme),
                            new String[] {
                                    view.getContext().getString(R.string.app_theme_auto),
                                    view.getContext().getString(R.string.app_theme_dark),
                                    view.getContext().getString(R.string.app_theme_light)
                            }, sCommonUtils.getInt("appTheme", 0, view.getContext()), view.getContext()) {

                        @Override
                        public void onItemSelected(int itemPosition) {
                            if (itemPosition == sCommonUtils.getInt("appTheme", 0, view.getContext())) {
                                return;
                            }
                            switch (itemPosition) {
                                case 2:
                                    sCommonUtils.saveInt("appTheme", 2, view.getContext());
                                    AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_NO);
                                    break;
                                case 1:
                                    sCommonUtils.saveInt("appTheme", 1, view.getContext());
                                    AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_YES);
                                    break;
                                default:
                                    sCommonUtils.saveInt("appTheme", 0, view.getContext());
                                    AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_FOLLOW_SYSTEM);
                                    break;
                            }
                            data.set(getBindingAdapterPosition(), new sSerializableItems(sCommonUtils.getDrawable(R.drawable.ic_theme, view.getContext()), view.getContext().getString(R.string.app_theme),
                                    sThemeUtils.getAppTheme(view.getContext()), null));
                            notifyItemChanged(getBindingAdapterPosition());
                        }
                    }.show();
                    break;
                case 1:
                    AppSettings.setUpdateInterval(mSummary, view.getContext()).show();
                    break;
                case 2:
                    AppSettings.setTimeFrame(mSummary, view.getContext()).show();
                    break;
                case 3:
                    new sExecutor() {
                        @Override
                        public void onPreExecute() {
                            mName.setVisibility(View.GONE);
                            mSummary.setText(view.getContext().getString(R.string.refreshing));
                            mProgress.setVisibility(View.VISIBLE);
                        }

                        @Override
                        public void doInBackground() {
                            PackageData.acquireRepoData(true, mSummary, mProgress, view.getContext());
                        }

                        @Override
                        public void onPostExecute() {
                            if (Common.getJSONObject() != null) {
                                mSummary.setText(view.getContext().getString(R.string.refresh_repo_summary, Common.getAdjustedDate(sCommonUtils.getLong("ucTimeStamp", 0, view.getContext()))));
                                mProgress.setVisibility(View.GONE);
                                mProgress.setIndeterminate(true);
                                mName.setVisibility(View.VISIBLE);
                                mSummary.setVisibility(View.VISIBLE);
                                AppSettings.showUpdateNotification(view.getContext());
                            }
                        }
                    }.execute();
                    break;
                case 5:
                    new sTranslatorUtils(view.getContext().getString(R.string.app_name), "https://gitlab.com/sunilpaulmathew/izzyondroid/-/blob/master/app/src/main/res/values/strings.xml",
                            (Activity) view.getContext()).show();
                    break;
            }
        }
    }

}