package in.sunilpaulmathew.izzyondroid.activities;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ProgressBar;

import androidx.activity.OnBackPressedCallback;
import androidx.appcompat.app.AppCompatActivity;

import com.google.android.material.button.MaterialButton;
import com.google.android.material.textview.MaterialTextView;

import in.sunilpaulmathew.izzyondroid.MainActivity;
import in.sunilpaulmathew.izzyondroid.R;
import in.sunilpaulmathew.izzyondroid.utils.Common;
import in.sunilpaulmathew.izzyondroid.utils.PackageData;
import in.sunilpaulmathew.sCommon.CommonUtils.sCommonUtils;
import in.sunilpaulmathew.sCommon.CommonUtils.sExecutor;

/*
 * Created by sunilpaulmathew <sunil.kde@gmail.com> on August 28, 2021
 */
public class WelcomeActivity extends AppCompatActivity {

    private ProgressBar mProgress;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_welcome);

        MaterialButton mStarButton = findViewById(R.id.start);
        MaterialTextView mMainText = findViewById(R.id.main_text);
        mProgress = findViewById(R.id.progress);

        mStarButton.setOnClickListener(v -> new sExecutor() {

            @Override
            public void onPreExecute() {
                mMainText.setText(getString(R.string.initializing));
                mStarButton.setVisibility(View.GONE);
                mProgress.setVisibility(View.VISIBLE);
                mProgress.setIndeterminate(false);
            }

            @Override
            public void doInBackground() {
                PackageData.acquireRepoData(true, mMainText, mProgress, v.getContext());
            }

            @Override
            public void onPostExecute() {
                if (Common.getJSONObject() != null) {
                    Intent intent = new Intent(v.getContext(), MainActivity.class);
                    startActivity(intent);
                    finish();
                } else {
                    sCommonUtils.toast(getString(R.string.initializing_failed), v.getContext()).show();
                    mMainText.setText(getString(R.string.welcome_message));
                    mStarButton.setVisibility(View.VISIBLE);
                    mProgress.setVisibility(View.GONE);
                    mProgress.setIndeterminate(true);
                }
            }
        }.execute());

        getOnBackPressedDispatcher().addCallback(new OnBackPressedCallback(true) {
            @Override
            public void handleOnBackPressed() {
                if (mProgress.getVisibility() == View.GONE) {
                    finish();
                }
            }
        });
    }

}