package in.sunilpaulmathew.izzyondroid;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.ProgressBar;

import androidx.activity.OnBackPressedCallback;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.app.ActivityCompat;
import androidx.viewpager.widget.ViewPager;

import com.google.android.material.bottomnavigation.BottomNavigationView;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textview.MaterialTextView;

import java.util.Objects;

import in.sunilpaulmathew.izzyondroid.activities.WelcomeActivity;
import in.sunilpaulmathew.izzyondroid.fragments.CategoryFragment;
import in.sunilpaulmathew.izzyondroid.fragments.InstalledFragment;
import in.sunilpaulmathew.izzyondroid.fragments.LatestFragment;
import in.sunilpaulmathew.izzyondroid.fragments.SettingsFragment;
import in.sunilpaulmathew.izzyondroid.utils.AppSettings;
import in.sunilpaulmathew.izzyondroid.utils.Common;
import in.sunilpaulmathew.izzyondroid.utils.PackageData;
import in.sunilpaulmathew.izzyondroid.utils.ShizukuInstaller;
import in.sunilpaulmathew.sCommon.Adapters.sPagerAdapter;
import in.sunilpaulmathew.sCommon.CommonUtils.sCommonUtils;
import in.sunilpaulmathew.sCommon.CommonUtils.sExecutor;
import in.sunilpaulmathew.sCommon.CrashReporter.sCrashReporter;
import in.sunilpaulmathew.sCommon.ThemeUtils.sThemeUtils;
import rikka.shizuku.Shizuku;

/*
 * Created by sunilpaulmathew <sunil.kde@gmail.com> on August 19, 2021
 */
public class MainActivity extends AppCompatActivity {

    private static boolean mExit;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        sThemeUtils.initializeAppTheme(this);
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        sCrashReporter crashReporter = new sCrashReporter(this);
        crashReporter.setAccentColor(Integer.MIN_VALUE);
        crashReporter.setTitleSize(20);
        crashReporter.initialize();

        BottomNavigationView mBottomNav = findViewById(R.id.bottom_navigation);
        ConstraintLayout mProgressLayout = findViewById(R.id.progress_layout);
        MaterialTextView mProgressText = findViewById(R.id.progress_text);
        ProgressBar mProgressBar = findViewById(R.id.progress);
        ViewPager mViewPager = findViewById(R.id.view_pager);

        if (Common.getIndexFile(this).exists()) {
            if (Common.getRawData() == null) {
                new sExecutor() {

                    @Override
                    public void onPreExecute() {
                        mBottomNav.setVisibility(View.GONE);
                        mProgressBar.setIndeterminate(false);
                        mProgressLayout.setVisibility(View.VISIBLE);
                        mProgressText.setText(getString(Common.isUpdateTime(MainActivity.this) ?
                                R.string.updating : R.string.loading));
                    }

                    @Override
                    public void doInBackground() {
                        PackageData.acquireRepoData(false, mProgressText, mProgressBar, MainActivity.this);
                    }

                    @Override
                    public void onPostExecute() {
                        mProgressLayout.setVisibility(View.GONE);
                        mProgressBar.setIndeterminate(true);
                        mBottomNav.setVisibility(View.VISIBLE);
                        mViewPager.setAdapter(getAdapter());
                        if (savedInstanceState == null) {
                            mViewPager.setCurrentItem(0);
                        }
                        AppSettings.showUpdateNotification(MainActivity.this);
                    }
                }.execute();
            } else {
                mViewPager.setAdapter(getAdapter());
                String mUpdateStatus = getIntent().getStringExtra(Common.getUpdateStatus());
                if (mUpdateStatus != null && mUpdateStatus.equals("UPDATE_AVAILABLE")) {
                    mViewPager.setCurrentItem(2);
                } else if (savedInstanceState == null) {
                    mViewPager.setCurrentItem(0);
                }
            }

            mBottomNav.setOnItemSelectedListener(item -> {
                if (item.getItemId() == R.id.nav_latest) {
                    mViewPager.setCurrentItem(0);
                } else if (item.getItemId() == R.id.nav_categories) {
                    mViewPager.setCurrentItem(1);
                } else if (item.getItemId() == R.id.nav_installed) {
                    mViewPager.setCurrentItem(2);
                } else if (item.getItemId() == R.id.nav_settings) {
                    mViewPager.setCurrentItem(3);
                }
                Objects.requireNonNull(mViewPager.getAdapter()).notifyDataSetChanged();
                return false;
            });

            mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
                @Override
                public void onPageScrolled(int position, final float positionOffset, final int positionOffsetPixels) {
                    mBottomNav.getMenu().getItem(position).setChecked(true);
                }

                @Override
                public void onPageSelected(int position) {
                }

                @Override
                public void onPageScrollStateChanged(int state) {
                }
            });

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU && checkCallingOrSelfPermission(
                    Manifest.permission.POST_NOTIFICATIONS) != PackageManager.PERMISSION_GRANTED) {
                new MaterialAlertDialogBuilder(this)
                        .setCancelable(false)
                        .setIcon(R.mipmap.ic_launcher)
                        .setTitle(getString(R.string.app_name))
                        .setMessage(getString(R.string.notification_permission_message))
                        .setNegativeButton(getString(R.string.cancel), (dialogInterface, i) -> {
                        })
                        .setPositiveButton(getString(R.string.request_permission), (dialogInterface, i) -> ActivityCompat.requestPermissions(
                                this, new String[] {
                                        Manifest.permission.POST_NOTIFICATIONS
                                }, 0)
                        ).show();
            } else {
                if (ShizukuInstaller.isShizukuSupported()) {
                    if (Shizuku.checkSelfPermission() != PackageManager.PERMISSION_GRANTED
                            && sCommonUtils.getBoolean("request_shizuku", true, this)) {
                        new MaterialAlertDialogBuilder(this)
                                .setCancelable(false)
                                .setIcon(R.mipmap.ic_launcher)
                                .setTitle(getString(R.string.app_name))
                                .setMessage(getString(R.string.shizuku_permission_message))
                                .setNegativeButton(getString(R.string.never_show), (dialogInterface, i) -> sCommonUtils.saveBoolean(
                                        "request_shizuku", false, this))
                                .setPositiveButton(getString(R.string.request_permission), (dialogInterface, i) -> Shizuku
                                        .requestPermission(0)
                                ).show();
                    } else {
                        ShizukuInstaller.ensureUserService(() -> sCommonUtils.toast("Access to the Shizuku service has been granted...", this).show());
                    }
                }
            }
        } else {
            Intent intent = new Intent(this, WelcomeActivity.class);
            startActivity(intent);
            finish();
        }

        getOnBackPressedDispatcher().addCallback(new OnBackPressedCallback(true) {
            @Override
            public void handleOnBackPressed() {
                if (mExit) {
                    mExit = false;
                    finish();
                } else {
                    sCommonUtils.toast(getString(R.string.press_back), MainActivity.this).show();
                    mExit = true;
                    new Handler().postDelayed(() -> mExit = false, 2000);
                }
            }
        });
    }

    private sPagerAdapter getAdapter() {
        sPagerAdapter mAdapter = new sPagerAdapter(getSupportFragmentManager());
        mAdapter.AddFragment(new LatestFragment(), null);
        mAdapter.AddFragment(new CategoryFragment(), null);
        mAdapter.AddFragment(new InstalledFragment(), null);
        mAdapter.AddFragment(new SettingsFragment(), null);
        return mAdapter;
    }

}