(ns utils.security.security-html
  (:require
    [clojure.string :as string]))

; Taken from https://github.com/sindresorhus/is-html

(def html-tags
  ["a"
   "abbr"
   "address"
   "area"
   "article"
   "aside"
   "audio"
   "b"
   "base"
   "bdi"
   "bdo"
   "blockquote"
   "body"
   "br"
   "button"
   "canvas"
   "caption"
   "cite"
   "code"
   "col"
   "colgroup"
   "data"
   "datalist"
   "dd"
   "del"
   "details"
   "dfn"
   "dialog"
   "div"
   "dl"
   "dt"
   "em"
   "embed"
   "fieldset"
   "figcaption"
   "figure"
   "footer"
   "form"
   "h1"
   "h2"
   "h3"
   "h4"
   "h5"
   "h6"
   "head"
   "header"
   "hgroup"
   "hr"
   "html"
   "i"
   "iframe"
   "img"
   "input"
   "ins"
   "kbd"
   "label"
   "legend"
   "li"
   "link"
   "main"
   "map"
   "mark"
   "math"
   "menu"
   "menuitem"
   "meta"
   "meter"
   "nav"
   "noscript"
   "object"
   "ol"
   "optgroup"
   "option"
   "output"
   "p"
   "param"
   "picture"
   "pre"
   "progress"
   "q"
   "rb"
   "rp"
   "rt"
   "rtc"
   "ruby"
   "s"
   "samp"
   "script"
   "section"
   "select"
   "slot"
   "small"
   "source"
   "span"
   "strong"
   "style"
   "sub"
   "summary"
   "sup"
   "svg"
   "table"
   "tbody"
   "td"
   "template"
   "textarea"
   "tfoot"
   "th"
   "thead"
   "time"
   "title"
   "tr"
   "track"
   "u"
   "ul"
   "var"
   "video"
   "wbr"])

(def basic-regex #"(?i)\s?<!doctype html>|(<html\b[^>]*>|<body\b[^>]*>|<x-[^>]+>)+")
(def tags-regex
  (->> html-tags
       (map #(str "<" % "\\b[^>]*>"))
       (string/join "|")))
(def full-regex (new js/RegExp tags-regex "i"))

(defn is-html?
  [text]
  (or (re-find basic-regex text)
      (re-find full-regex text)))
