(ns status-im.db
  (:require
    [legacy.status-im.fleet.core :as fleet]
    [react-native.core :as rn]
    [status-im.config :as config]
    [status-im.contexts.shell.activity-center.events :as activity-center]
    [status-im.contexts.wallet.db :as wallet]))

;; initial state of app-db
(def app-db
  {:activity-center                    {:filter {:status (:filter-status activity-center/defaults)
                                                 :type   (:filter-type activity-center/defaults)}}
   :contacts/contacts                  {}
   :pairing/installations              {}
   :group/selected-contacts            #{}
   :chats                              {}
   :currencies                         {}
   :current-chat-id                    nil
   :group-chat/selected-participants   #{}
   :group-chat/deselected-members      #{}
   :sync-state                         :done
   :link-previews-whitelist            []
   :app-state                          "active"
   :wallet                             wallet/defaults
   :peer-stats/count                   0
   :node-info                          {}
   :peers-summary                      []
   :transport/message-envelopes        {}
   :mailserver/mailservers             (fleet/default-mailservers {})
   :chat/cooldowns                     0
   :chat/inputs                        {}
   :chat/cooldown-enabled?             false
   :chat/last-outgoing-message-sent-at 0
   :chat/spam-messages-frequency       0
   :privacy-mode/privacy-mode-enabled? false
   :chats-home-list                    #{}
   :home-items-show-number             20
   :toasts                             {:ordered '() :toasts {}}
   :tooltips                           {}
   :dimensions/window                  (rn/get-window)
   :registry                           {}
   :visibility-status-updates          {}
   :stickers/packs-pending             #{}
   :settings/change-password           {}
   :keycard                            {}
   :theme                              :dark
   :log-level/pre-login-log-level      (config/log-level)
   :gate.market/last-fetched-page      0
   :domain.market/leaderboard          {}
   :domain.market/prices               {}
   :domain.market/tokens               {}})
