(ns status-im.contexts.wallet.account.share-address.view
  (:require
    [quo.context]
    [quo.core :as quo]
    [react-native.core :as rn]
    [react-native.platform :as platform]
    [react-native.safe-area :as safe-area]
    [status-im.contexts.wallet.account.share-address.style :as style]
    [utils.i18n :as i18n]
    [utils.image-server :as image-server]
    [utils.re-frame :as rf]))

(def qr-size 500)

(defn- share-action
  [address share-title]
  (rf/dispatch [:open-share
                {:options (if platform/ios?
                            {:activityItemSources [{:placeholderItem {:type    :text
                                                                      :content address}
                                                    :item            {:default {:type :text
                                                                                :content
                                                                                address}}
                                                    :linkMetadata    {:title share-title}}]}
                            {:title     share-title
                             :subject   share-title
                             :message   address
                             :isNewTask true})}]))

(defn view
  []
  (let [padding-top (:top safe-area/insets)]
    (fn []
      (let [{:keys [address color emoji watch-only?]
             :as   account}     (rf/sub [:wallet/current-viewing-account])
            share-title         (str (:name account) " " (i18n/label :t/address))
            qr-url              address
            qr-media-server-uri (image-server/get-qr-image-uri-for-any-url
                                 {:url         qr-url
                                  :port        (rf/sub [:mediaserver/port])
                                  :qr-size     qr-size
                                  :error-level :highest})

            {:keys [status]}    (quo.context/use-screen-params)
            title               (case status
                                  :share   (i18n/label :t/share-address)
                                  :receive (i18n/label :t/receive)
                                  nil)]

        [quo/overlay {:type :shell}
         [rn/view
          {:flex        1
           :padding-top padding-top}
          [quo/page-nav
           {:icon-name           :i/close
            :on-press            #(rf/dispatch [:navigate-back])
            :background          :blur
            :right-side          [{:icon-name :i/scan
                                   :on-press  (fn []
                                                (rf/dispatch [:navigate-back])
                                                (rf/dispatch [:open-modal :screen/shell-qr-reader]))}]
            :accessibility-label :top-bar}]
          [quo/page-top
           {:title           title
            :container-style style/header-container}]
          [rn/view {:style {:padding-horizontal 20}}
           [quo/share-qr-code
            {:type                (if watch-only? :watched-address :wallet)
             :qr-image-uri        qr-media-server-uri
             :qr-data             qr-url
             :on-share-press      #(share-action qr-url share-title)
             :profile-picture     nil
             :full-name           (:name account)
             :customization-color color
             :emoji               emoji}]]]]))))
