(ns status-im.contexts.onboarding.common.carousel.view
  (:require
    [quo.core :as quo]
    [react-native.core :as rn]
    [react-native.gesture :as gesture]
    [react-native.navigation :as navigation]
    [react-native.reanimated :as reanimated]
    [status-im.contexts.onboarding.common.carousel.animation :as animation]
    [status-im.contexts.onboarding.common.carousel.style :as style]
    [utils.re-frame :as rf]))

(defn header-text-view
  [index window-width header-text]
  [rn/view {:style (style/header-text-view window-width)}
   [quo/text
    {:style  style/carousel-text
     :weight :semi-bold
     :size   :heading-2}
    (get-in header-text [index :text])]
   [quo/text
    {:style style/carousel-sub-text}
    (get-in header-text [index :sub-text])]])

(defn content-view
  [{:keys [window-width status-bar-height index header-text header-background]} content]
  (let [content-width (* 3 window-width)]
    [rn/view {:style {:flex 1}}
     [rn/view {:style (style/header-container status-bar-height content-width index header-background)}
      (for [index (range 3)]
        ^{:key index}
        [header-text-view index window-width header-text])]
     (when content content)]))

(defn progress-bar
  [{:keys [static? progress-bar-width]}]
  [rn/view
   {:style (style/progress-bar progress-bar-width)}
   [rn/view {:style (style/progress-bar-item static? false)}]
   [rn/view {:style (style/progress-bar-item static? false)}]
   [rn/view {:style (style/progress-bar-item static? true)}]])

(defn f-dynamic-progress-bar
  [{:keys [progress-bar-width animate? progress]}]
  (let [width          (animation/dynamic-progress-bar-width progress-bar-width animate? progress)
        container-view (if animate? reanimated/view rn/view)]
    [container-view {:style (style/dynamic-progress-bar width animate?)}
     [progress-bar
      {:static?            false
       :progress-bar-width progress-bar-width}]]))

(defn f-view
  [{:keys [animate? progress paused? header-text background header-background gesture is-dragging?
           drag-amount]}]
  (let [window-width (rf/sub [:dimensions/window-width])
        status-bar-height (:status-bar-height @navigation/constants)
        progress-bar-width (- window-width 40)
        carousel-left
        (animation/carousel-left-position window-width animate? progress is-dragging? drag-amount)
        container-view (if animate? reanimated/view rn/view)
        identified-gesture
        (case gesture
          :swipeable (animation/composed-gestures progress paused? is-dragging? drag-amount)
          :tappable  (animation/tap-gesture progress paused?)
          nil)]
    [rn/view {:style {:flex 1}}
     [gesture/gesture-detector {:gesture identified-gesture}
      [container-view {:style (style/carousel-container carousel-left animate? (* 3 window-width))}
       (for [index (range 1)]
         ^{:key index}
         [content-view
          {:window-width      window-width
           :status-bar-height status-bar-height
           :index             index
           :header-text       header-text
           :header-background header-background}
          background])]]
     [rn/view
      {:style (style/progress-bar-container
               progress-bar-width
               status-bar-height)}
      [progress-bar
       {:static?            true
        :progress-bar-width progress-bar-width}]
      [:f> f-dynamic-progress-bar
       {:progress-bar-width progress-bar-width
        :animate?           animate?
        :progress           progress}]]]))

(defn view [props] [:f> f-view props])
