(ns status-im.constants
  (:require
    [clojure.string :as string]))

(def ^:const ms-in-bg-for-require-bioauth 5000)

(def ^:const content-type-text 1)
(def ^:const content-type-sticker 2)
(def ^:const content-type-status 3)
(def ^:const content-type-emoji 4)
(def ^:const content-type-system-text 6)
(def ^:const content-type-image 7)
(def ^:const content-type-audio 8)
(def ^:const content-type-community 9)
(def ^:const content-type-gap 10)
(def ^:const content-type-contact-request 11)
(def ^:const content-type-system-pinned-message 14)
(def ^:const content-type-system-message-mutual-event-sent 15)
(def ^:const content-type-system-message-mutual-event-accepted 16)
(def ^:const content-type-system-message-mutual-event-removed 17)
(def ^:const content-type-bridge-message 18)

;; Not implemented in status-go, only used for testing/ui work
(def ^:const content-type-gif 100)
(def ^:const content-type-album 102)

(def ^:const contact-request-state-none 0)
(def ^:const contact-request-state-mutual 1)
(def ^:const contact-request-state-sent 2)
(def ^:const contact-request-state-received 3)
(def ^:const contact-request-state-dismissed 4)

(def ^:const contact-verification-status-pending 1)
(def ^:const contact-verification-status-accepted 2)
(def ^:const contact-verification-status-declined 3)
(def ^:const contact-verification-status-trusted 5)
(def ^:const contact-verification-status-untrustworthy 6)

(def ^:const activity-center-membership-status-idle 0)
(def ^:const activity-center-membership-status-pending 1)
(def ^:const activity-center-membership-status-accepted 2)
(def ^:const activity-center-membership-status-declined 3)

;; Choose the maximum number of notifications that *usually/safely* fit on
;; most screens, so that the UI doesn't have to needlessly render
;; notifications.
(def ^:const notifications-per-page 7)

(def ^:const mute-for-15-mins-type 1)
(def ^:const mute-for-1-hour-type 2)
(def ^:const mute-for-8-hours-type 3)
(def ^:const mute-for-1-week 4)
(def ^:const mute-till-unmuted 5)
(def ^:const un-muted 0)

(def ^:const mute-undo-time-limit-ms 4000)

(def ^:const activity-center-mark-all-as-read-undo-time-limit-ms 4000)
(def ^:const activity-center-max-unread-count 99)

(def ^:const emoji-reaction-love 1)
(def ^:const emoji-reaction-thumbs-up 2)
(def ^:const emoji-reaction-thumbs-down 3)
(def ^:const emoji-reaction-laugh 4)
(def ^:const emoji-reaction-sad 5)
(def ^:const emoji-reaction-angry 6)

(def ^:const one-to-one-chat-type 1)
(def ^:const public-chat-type 2)
(def ^:const private-group-chat-type 3)
(def ^:const profile-chat-type 4)
(def ^:const timeline-chat-type 5)
(def ^:const community-chat-type 6)

(def ^:const chat-preview-type-community 0)
(def ^:const chat-preview-type-non-community 1)

(def ^:const contact-request-message-state-pending 1)
(def ^:const contact-request-message-state-accepted 2)
(def ^:const contact-request-message-state-declined 3)
(def ^:const contact-request-message-max-length 280)

(def ^:const key-pair-name-max-length 20)
(def ^:const key-pair-name-min-length 5)

(def request-to-join-pending-state 1)

(def reactions
  {emoji-reaction-love        :reaction/love
   emoji-reaction-thumbs-up   :reaction/thumbs-up
   emoji-reaction-thumbs-down :reaction/thumbs-down
   emoji-reaction-laugh       :reaction/laugh
   emoji-reaction-sad         :reaction/sad
   emoji-reaction-angry       :reaction/angry})

(def ^:const invitation-state-requested 1)
(def ^:const invitation-state-rejected 2)
(def ^:const invitation-state-approved 3)
(def ^:const message-type-one-to-one 1)
(def ^:const message-type-private-group-system-message 4)


(def ^:const profile-default-color :blue)
(def ^:const profile-name-max-length 20)
(def ^:const profile-bio-max-length 240)
(def ^:const profile-default-currency :usd)

(def ^:const profile-pictures-show-to-contacts-only 1)
(def ^:const profile-pictures-show-to-everyone 2)
(def ^:const profile-pictures-show-to-none 3)

(def ^:const profile-pictures-visibility-contacts-only 1)
(def ^:const profile-pictures-visibility-everyone 2)
(def ^:const profile-pictures-visibility-none 3)

(def ^:const min-password-length 6)
(def ^:const pincode-length 6)
(def ^:const new-password-min-length 10)
(def ^:const new-password-max-length 100)
(def ^:const max-group-chat-participants 20)
(def ^:const max-group-chat-name-length 24)
(def ^:const default-number-of-messages 20)
(def ^:const default-number-of-pin-messages 3)

(def ^:const password-tips
  [:lower-case?
   :upper-case?
   :numbers?
   :symbols?])

(def ^:const strength-status
  {1 :very-weak
   2 :weak
   3 :okay
   4 :strong
   5 :very-strong})

(def ^:const mailserver-password "status-offline-inbox")


(def ^:const community-no-membership-access 1)
(def ^:const community-invitation-only-access 2)
(def ^:const community-on-request-access 3)

(def ^:const community-token-permission-become-admin 1)
(def ^:const community-token-permission-become-member 2)
(def ^:const community-token-permission-become-token-master 5)
(def ^:const community-token-permission-become-token-owner 6)
(def ^:const community-role-permissions
  #{community-token-permission-become-admin
    community-token-permission-become-member
    community-token-permission-become-token-master
    community-token-permission-become-token-owner})

(def ^:const community-token-type-erc20 1)
(def ^:const community-token-type-erc721 2)


(def ^:const community-request-to-join-state-pending 1)
(def ^:const community-request-to-join-state-accepted 3)
(def ^:const community-id-length 68)


; BIP44 Wallet Root Key, the extended key from which any wallet can be derived
(def ^:const path-wallet-root "m/44'/60'/0'/0")
; EIP1581 Root Key, the extended key from which any whisper key/encryption key can be derived
(def ^:const path-eip1581 "m/43'/60'/1581'")
; BIP44-0 Wallet key, the default wallet key
(def ^:const path-default-wallet (str path-wallet-root "/0"))
; EIP1581 Chat Key 0, the default whisper key
(def ^:const path-whisper (str path-eip1581 "/0'/0"))

(def ^:const path-ropsten-testnet "m/44'/1'/0")
(def ^:const path-ledger "m/44'/60'/0'")
(def ^:const path-ledger-live "m/44'/60'")
(def ^:const path-keepkey "m/44'/60'")


(def regx-string-universal-link-encoded-data-base64
  "(?:[A-Za-z0-9+/_-]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?")
(def regx-string-any-ascii "[\\x00-\\x7F]")
(def regx-string-compressed-key "zQ3[0-9A-HJ-NP-Za-km-z]{46}")
(def regx-string-public-key "0x04[0-9a-f]{128}")
(def regx-compressed-key (re-pattern (str "^" regx-string-compressed-key "$")))
(def regx-public-key (re-pattern (str "^" regx-string-public-key "$")))
(def regx-private-key-hex #"^0x[0-9a-fA-F]{64}$")
(def regx-private-key #"^[0-9a-fA-F]{64}$")
(def regx-emoji
  #"^((?:[\u261D\u26F9\u270A-\u270D]|\uD83C[\uDF85\uDFC2-\uDFC4\uDFC7\uDFCA-\uDFCC]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66-\uDC69\uDC6E\uDC70-\uDC78\uDC7C\uDC81-\uDC83\uDC85-\uDC87\uDCAA\uDD74\uDD75\uDD7A\uDD90\uDD95\uDD96\uDE45-\uDE47\uDE4B-\uDE4F\uDEA3\uDEB4-\uDEB6\uDEC0\uDECC]|\uD83E[\uDD18-\uDD1C\uDD1E\uDD1F\uDD26\uDD30-\uDD39\uDD3D\uDD3E\uDDD1-\uDDDD])(?:\uD83C[\uDFFB-\uDFFF])?|(?:[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u270A\u270B\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF93\uDFA0-\uDFCA\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF4\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC3E\uDC40\uDC42-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDD7A\uDD95\uDD96\uDDA4\uDDFB-\uDE4F\uDE80-\uDEC5\uDECC\uDED0-\uDED2\uDEEB\uDEEC\uDEF4-\uDEF8]|\uD83E[\uDD10-\uDD3A\uDD3C-\uDD3E\uDD40-\uDD45\uDD47-\uDD4C\uDD50-\uDD6B\uDD80-\uDD97\uDDC0\uDDD0-\uDDE6])|(?:[#\*0-9\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u231A\u231B\u2328\u23CF\u23E9-\u23F3\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB-\u25FE\u2600-\u2604\u260E\u2611\u2614\u2615\u2618\u261D\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u2648-\u2653\u2660\u2663\u2665\u2666\u2668\u267B\u267F\u2692-\u2697\u2699\u269B\u269C\u26A0\u26A1\u26AA\u26AB\u26B0\u26B1\u26BD\u26BE\u26C4\u26C5\u26C8\u26CE\u26CF\u26D1\u26D3\u26D4\u26E9\u26EA\u26F0-\u26F5\u26F7-\u26FA\u26FD\u2702\u2705\u2708-\u270D\u270F\u2712\u2714\u2716\u271D\u2721\u2728\u2733\u2734\u2744\u2747\u274C\u274E\u2753-\u2755\u2757\u2763\u2764\u2795-\u2797\u27A1\u27B0\u27BF\u2934\u2935\u2B05-\u2B07\u2B1B\u2B1C\u2B50\u2B55\u3030\u303D\u3297\u3299]|\uD83C[\uDC04\uDCCF\uDD70\uDD71\uDD7E\uDD7F\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE02\uDE1A\uDE2F\uDE32-\uDE3A\uDE50\uDE51\uDF00-\uDF21\uDF24-\uDF93\uDF96\uDF97\uDF99-\uDF9B\uDF9E-\uDFF0\uDFF3-\uDFF5\uDFF7-\uDFFF]|\uD83D[\uDC00-\uDCFD\uDCFF-\uDD3D\uDD49-\uDD4E\uDD50-\uDD67\uDD6F\uDD70\uDD73-\uDD7A\uDD87\uDD8A-\uDD8D\uDD90\uDD95\uDD96\uDDA4\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA-\uDE4F\uDE80-\uDEC5\uDECB-\uDED2\uDEE0-\uDEE5\uDEE9\uDEEB\uDEEC\uDEF0\uDEF3-\uDEF8]|\uD83E[\uDD10-\uDD3A\uDD3C-\uDD3E\uDD40-\uDD45\uDD47-\uDD4C\uDD50-\uDD6B\uDD80-\uDD97\uDDC0\uDDD0-\uDDE6])\uFE0F|[\t-\r \xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000\uFEFF])+$")
(def regx-string-universal-link
  (str "((^https?://status.app/)|(^status-app://))"
       "("
       (string/join
        "|"
        [(str "u/" regx-string-universal-link-encoded-data-base64 "#" regx-string-compressed-key)
         (str "u#" regx-string-compressed-key)
         (str "c/" regx-string-universal-link-encoded-data-base64 "#" regx-string-compressed-key)
         (str "c#" regx-string-compressed-key)
         (str "cc/" regx-string-universal-link-encoded-data-base64 "#" regx-string-compressed-key)
         (str "p/" regx-string-any-ascii "+")
         (str "cr/" regx-string-any-ascii "+")
         (str "g/" regx-string-any-ascii "+")
         (str "wallet/" regx-string-any-ascii "+")])
       ")$"))
(def regx-universal-link (re-pattern regx-string-universal-link))
(def regx-deep-link #"((^ethereum:.*)|(^status-app://[\x00-\x7F]+)|(^wc://.*))")
(def regx-ens #"^(?=.{5,255}$)([a-zA-Z0-9-]+\.)*[a-zA-Z0-9-]+\.[a-zA-Z]{2,}$")
(def regx-starts-with-uuid #"^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}")

;; Wallet Connect
(def ^:const wallet-connect-metadata-icon
  "https://res.cloudinary.com/dhgck7ebz/image/upload/f_auto,c_limit,w_1080,q_auto/Brand/Logo%20Section/Mark/Mark_01")
(def ^:const wallet-connect-metadata-url "https://status.app")
(def ^:const wallet-connect-metadata-redirect-native "status-app://")

(def ^:const wallet-connect-personal-sign-method "personal_sign")
(def ^:const wallet-connect-eth-sign-method "eth_sign")
(def ^:const wallet-connect-eth-send-transaction-method "eth_sendTransaction")
(def ^:const wallet-connect-eth-sign-transaction-method "eth_signTransaction")
(def ^:const wallet-connect-eth-sign-typed-method "eth_signTypedData")
(def ^:const wallet-connect-eth-sign-typed-v4-method "eth_signTypedData_v4")
(def ^:const wallet-connect-supported-methods
  #{wallet-connect-personal-sign-method
    wallet-connect-eth-send-transaction-method
    wallet-connect-eth-sign-typed-method
    wallet-connect-eth-sign-typed-v4-method})
(def ^:const wallet-connect-supported-events #{"accountsChanged" "chainChanged"})
(def ^:const wallet-connect-session-proposal-event "session_proposal")
(def ^:const wallet-connect-session-request-event "session_request")
(def ^:const wallet-connect-session-delete-event "session_delete")
(def ^:const wallet-connect-user-rejected-error-key "USER_REJECTED")
(def ^:const wallet-connect-user-disconnected-reason-key "USER_DISCONNECTED")
(def ^:const wallet-connect-user-rejected-chains-error-key "USER_REJECTED_CHAINS")
(def ^:const wallet-connect-message-signing-methods
  #{wallet-connect-personal-sign-method
    wallet-connect-eth-sign-typed-method
    wallet-connect-eth-sign-typed-v4-method})
(def ^:const wallet-connect-transaction-methods
  #{wallet-connect-eth-send-transaction-method})

(def ^:const transaction-pending-type-wallet-connect-transfer "WalletConnectTransfer")

(def ^:const token-sort-priority {"SNT" 1 "STT" 1 "ETH" 2 "DAI" 3})

(def ^:const token-display-precision 6)

(def ^:const dapp-permission-contact-code "contact-code")
(def ^:const dapp-permission-web3 "web3")
(def ^:const dapp-permission-qr-code "qr-code")
(def ^:const api-response "api-response")
(def ^:const api-request "api-request")
(def ^:const history-state-changed "history-state-changed")
(def ^:const web3-send-async-read-only "web3-send-async-read-only")
(def ^:const web3-send-async-callback "web3-send-async-callback")
(def ^:const two-mins (* 2 60))
(def ^:const one-day (* 60 60 24))
(def ^:const three-days (* one-day 3))
(def ^:const nine-days (* one-day 9))
(def ^:const one-week (* one-day 7))
(def ^:const one-month (* one-day 31))

(def ^:const create-account-link "https://status.app/help/wallet/create-wallet-accounts")
(def ^:const mobile-upvote-link "https://discuss.status.app/c/features/51")
(def ^:const status-help-link "https://status.app/help")

(def ^:const visibility-status-unknown 0)
(def ^:const visibility-status-automatic 1)
(def ^:const visibility-status-dnd 2)
(def ^:const visibility-status-always-online 3)
(def ^:const visibility-status-inactive 4)

(def ^:const sticker-pack-status-installed 1)
(def ^:const sticker-pack-status-pending 2)
(def ^:const sticker-pack-status-owned 3)

(def ^:const community-member-role-moderator 3)

(def ^:const delete-message-undo-time-limit-ms 4000)
(def ^:const delete-message-for-me-undo-time-limit-ms 4000)

(def ^:const max-album-photos 6)
(def ^:const image-size 146)

(def album-image-sizes ; sometimes we subtract 1 or 0.5 for padding
  {2        {0 image-size
             1 image-size}
   3        {0 [(* image-size 2) (* image-size 1.25)]
             1 [(- image-size 0.5) (dec (* image-size 0.75))]
             2 [(- image-size 0.5) (dec (* image-size 0.75))]}
   4        {0 image-size
             1 image-size
             2 image-size
             3 image-size}
   5        {0 image-size
             1 image-size
             2 (dec (* image-size 0.67))
             3 (dec (* image-size 0.67))
             4 (dec (* image-size 0.67))}
   :default {0 image-size
             1 image-size
             2 (- (* image-size 0.5) 0.5)
             3 (- (* image-size 0.5) 0.5)
             4 (- (* image-size 0.5) 0.5)
             5 (- (* image-size 0.5) 0.5)}})

;; any message that comes after this amount of ms will be grouped separately
(def ^:const group-ms 300000)

(def ^:const local-pairing-connection-string-identifier
  "If any string begins with cs we know its a connection string.
  This is useful when we read QR codes we know it is a connection string if it begins with this identifier.
  An example of a connection string is -> cs2:5vd6J6:Jfc:27xMmHKEYwzRGXcvTtuiLZFfXscMx4Mz8d9wEHUxDj4p7:EG7Z13QScfWBJNJ5cprszzDQ5fBVsYMirXo8MaQFJvpF:3 "
  "cs")

(def ^:const local-pairing-role-sender "sender")
(def ^:const local-pairing-role-receiver "receiver")

;; sender and receiver events
(def ^:const local-pairing-event-connection-success "connection-success")
(def ^:const local-pairing-event-connection-error "connection-error")
(def ^:const local-pairing-event-transfer-success "transfer-success")
(def ^:const local-pairing-event-transfer-error "transfer-error")


;; receiver events
(def ^:const local-pairing-event-received-account "received-account")
(def ^:const local-pairing-event-process-error "process-error")
(def ^:const local-pairing-event-errors
  #{local-pairing-event-connection-error
    local-pairing-event-transfer-error
    local-pairing-event-process-error})

(def ^:const local-pairing-action-connect 1)
(def ^:const local-pairing-action-pairing-account 2)
(def ^:const local-pairing-action-pairing-installation 4)
(def ^:const local-pairing-action-keystore-files-transfer 6)

(def ^:const serialization-key
  "We pass this serialization key as a parameter to MultiformatSerializePublicKey
  function at status-go, This key determines the output base of the serialization.
  according to https://specs.status.im/spec/2#public-key-serialization we serialize
  keys with base58btc encoding"
  "z")

(def ^:const deserialization-key
  "We pass this deserialization key as a parameter to MultiformatDeserializePublicKey
  function at status-go, This key determines the output base of the deserialization.
  according to https://specs.status.im/spec/2#public-key-serialization we deserialize
  keys with base16 hexadecimal encoding"
  "f")

(def ^:const appearance-type-system 0)
(def ^:const appearance-type-light 1)
(def ^:const appearance-type-dark 2)


(def ^:const everyone-mention-id "0x00001")

(def ^:const empty-category-id :communities/not-categorized)

(def ^:const seed-phrase-valid-length #{12 18 24})

(def ^:const auth-method-password "password")
(def ^:const auth-method-biometric "biometric")
(def ^:const auth-method-none "none")

;; NOTE all android biometrics falls under :Biometrics
(def ^:const biometrics-type-android :Biometrics)
(def ^:const biometrics-type-touch-id :TouchID)
(def ^:const biometrics-type-face-id :FaceID)

(def ^:const audio-max-duration-ms 120000)

(def ^:const onboarding-modal-animation-duration 300)
(def ^:const onboarding-modal-animation-delay 400)

(def ^:const initials-avatar-font-conf
  "we pass absolute font file path and uppercase ratio to status-go for media
  server to serve initials avatar image
  `:uppercase-ratio` is uppercase-height/line-height for Inter-Medium"
  {:ios             "Inter-Medium.otf"
   :android         "Inter-Medium.ttf"
   :uppercase-ratio 0.603861228044709})

(def ^:const ens-action-type-register 1)
(def ^:const ens-action-type-set-pub-key 2)

;; wallet

(def opensea-url-names
  {:ethereum "ethereum"
   :sepolia  "sepolia"})

(def ^:const mainnet-short-name "eth")

(def ^:const layer-1-network 1)
(def ^:const layer-2-network 2)

(def ^:const chain-id-separator ":")

(def ^:const account-default-customization-color :blue)

(def ^:const wallet-account-name-max-length 20)

(def ^:const gas-rate-low 0)
(def ^:const gas-rate-medium 1)
(def ^:const gas-rate-high 2)
(def ^:const gas-rate-custom 3)
(def ^:const send-type-transfer 0)
(def ^:const send-type-bridge 5)
(def ^:const send-type-erc-721-transfer 6)
(def ^:const send-type-erc-1155-transfer 7)
(def ^:const send-type-swap 8)

(def ^:const bridge-name-hop "Hop")

;; remove the decimal from the token symbol once we move to CoinGecko token list
(def ^:const bridge-assets #{"ETH" "USDT (EVM)" "USDC (EVM)" "DAI"})

(def ^:const wallet-contract-type-erc-1155 3)

(def ^:const alert-banner-height 40)

(def ^:const sheet-screen-handle-height 20)

(def ^:const status-hostname "status.app")
(def ^:const get-keycard-url "https://get.keycard.tech/")

(def ^:const community-joined-notification-type "communityJoined")

(def ^:const default-telemetry-server-url "https://telemetry.status.im")

(def ^:const contact-item-height 56)
(def ^:const page-nav-height 56)
(def ^:const currency-item-height 64)

(def ^:const slippages [0.1 0.5 1])
(def ^:const default-slippage 0.5)
(def ^:const max-recommended-slippage 5)
(def ^:const max-slippage 30)
(def ^:const max-slippage-decimal-places 2)
(def ^:const swap-provider-paraswap
  {:name                     :paraswap
   :full-name                "ParaSwap"
   :color                    :blue
   :contract-address         "0x6a000f20005980200259b80c5102003040001068"
   :terms-and-conditions-url "https://files.paraswap.io/tos_v4.pdf"})
(def ^:const swap-providers
  {:paraswap swap-provider-paraswap})
(def ^:const swap-tokens-my :my)
(def ^:const swap-tokens-popular :popular)

;; The 15% buffer accounts for Ethereum's EIP-1559 fee mechanism, where the base fee can increase
;; by up to 12.5% per block in periods of high congestion. The extra 2.5% provides additional
;; safety to prevent failed transactions due to rapid gas price fluctuations.
(def ^:const eth-max-fee-buffer-percent 15)

(def ^:const transaction-status-success "Success")
(def ^:const transaction-status-pending "Pending")
(def ^:const transaction-status-failed "Failed")

(def ^:const eth-send-amount-decimal 4)
(def ^:const min-token-decimals-to-display 6)
(def ^:const swap-proposal-refresh-interval-ms 15000)

(def router-error-code-generic "0")
(def router-error-code-paraswap-custom-error "WPP-030")
(def router-error-code-price-timeout "WPP-037")
(def router-error-code-not-enough-liquidity "WPP-038")
(def router-error-code-price-impact-too-high "WPP-039")
(def router-error-code-not-enough-native-balance "WR-002")

(def ^:const wallet-transaction-estimation
  {:unknown                 0
   :less-than-one-minute    1
   :less-than-three-minutes 2
   :less-than-five-minutes  3
   :more-than-five-minutes  4})

(def ^:const wallet-connect-transaction-refresh-interval-ms 10000)

;; About app links
(def ^:const status-app-url "http://status.app")
(def ^:const go-waku-url "https://github.com/waku-org/go-waku")
(def ^:const status-go-url "https://github.com/status-im/status-go")
(def ^:const status-mobile-url "https://github.com/status-im/status-mobile")

(def ^:const wc-connection-string-identifier "wc")

(def ^:const max-allowed-watched-accounts 20)

(def ^:const pre-login-log-level-key "pre-login-log-level")
(def ^:const report-email "error-reports@status.im")

;; Community help links
(def ^:const create-community-help-url
  "https://status.app/help/communities/create-a-status-community#create-a-status-community")
