(ns quo.components.cards.wallet-card.view
  (:require [quo.components.cards.wallet-card.schema :as component-schema]
            [quo.components.cards.wallet-card.style :as style]
            [quo.components.icon :as icon]
            [quo.components.markdown.text :as text]
            [quo.context :as quo.context]
            [react-native.core :as rn]
            [react-native.fast-image :as fast-image]
            [schema.core :as schema]))

(defn- view-internal
  [{:keys [image title subtitle dismissible? on-press on-press-close container-style]}]
  (let [theme (quo.context/use-theme)]
    [rn/view {:style (style/root-container theme container-style)}
     [rn/pressable
      {:on-press            on-press
       :accessibility-label :wallet-card}
      [rn/view {:style style/top-container}
       [fast-image/fast-image
        {:style               style/image
         :source              image
         :accessibility-label :image}]
       (when dismissible?
         [rn/pressable
          {:on-press            on-press-close
           :accessibility-label :icon-container
           :hit-slop            {:top 5 :bottom 5 :left 5 :right 5}}
          [icon/icon :i/close
           {:size                12
            :accessibility-label :close-icon}]])]
      [text/text
       {:style           (style/title theme)
        :size            :paragraph-1
        :weight          :semi-bold
        :number-of-lines 1}
       title]
      [text/text
       {:style           (style/subtitle theme)
        :size            :paragraph-2
        :weight          :regular
        :number-of-lines 1}
       subtitle]]]))

(def view (schema/instrument #'view-internal component-schema/?schema))
