// This code has pieces that were autogenerated but is now managed manually
// Here lies the node bindings used for integration tests
// These are basically C calls to exported status-go functions
// Along 1 additional Poll function to get signals to work
// function names registered here in init() are used in various places
// ref -> status-mobile/src/tests/test_utils.cljs

#include <node.h>
#include <string>
#include <queue>

#include "../../../result/libstatus.h"

namespace status {

using v8::Exception;
using v8::FunctionCallbackInfo;
using v8::Function;
using v8::Persistent;
using v8::Context;
using v8::NewStringType;
using v8::Isolate;
using v8::Local;
using v8::Object;
using v8::String;
using v8::Number;
using v8::Value;


void _MultiAccountGenerateAndDeriveAddresses(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for MultiAccountGenerateAndDeriveAddresses")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'paramsJSON'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = MultiAccountGenerateAndDeriveAddresses(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _MultiAccountImportPrivateKey(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for MultiAccountImportPrivateKey")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'paramsJSON'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = MultiAccountImportPrivateKey(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _MultiAccountLoadAccount(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for MultiAccountLoadAccount")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'paramsJSON'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = MultiAccountLoadAccount(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;
}

void _MultiAccountReset(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();

	if (args.Length() != 0) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for MultiAccountReset")));
		return;
	}

	// Check the argument types


	// Call exported Go function, which returns a C string
	char *c = MultiAccountReset();

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;
}

void _MultiAccountDeriveAddresses(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for MultiAccountDeriveAddresses")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'paramsJSON'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = MultiAccountDeriveAddresses(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;
}

void _MultiAccountImportMnemonic(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for MultiAccountImportMnemonic")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'paramsJSON'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = MultiAccountImportMnemonic(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _MultiAccountGenerate(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for MultiAccountGenerate")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'paramsJSON'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = MultiAccountGenerate(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;
}

void _MultiAccountStoreDerivedAccounts(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for MultiAccountStoreDerivedAccounts")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'paramsJSON'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = MultiAccountStoreDerivedAccounts(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;
}

void _MultiAccountStoreAccount(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for MultiAccountStoreAccount")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'paramsJSON'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = MultiAccountStoreAccount(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;
}

void _InitializeApplication(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for InitializeApplication")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for request")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = InitializeApplication(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;
}

void _InitKeystore(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for InitKeystore")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'keydir'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = InitKeystore(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;
}

void _StopCPUProfiling(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();

	if (args.Length() != 0) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for StopCPUProfiling")));
		return;
	}

	// Check the argument types




	// Call exported Go function, which returns a C string
	char *c = StopCPUProfiling();

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _DecodeParameters(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for DecodeParameters")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'decodeParamJSON'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = DecodeParameters(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;

}

void _HexToNumber(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for HexToNumber")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'hex'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = HexToNumber(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;

}

void _NumberToHex(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for NumberToHex")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'numString'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = NumberToHex(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;

}

void _CheckAddressChecksum(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for CheckAddressChecksum")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'address'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = CheckAddressChecksum(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;

}

void _Fleets(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
	// Call exported Go function, which returns a C string
	char *c = Fleets();

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;
}


void _IsAddress(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for IsAddress")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'address'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = IsAddress(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;

}

void _Sha3(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for Sha3")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'str'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = Sha3(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;

}

void _SerializeLegacyKey(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for SerializeLegacyKey")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'str'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = SerializeLegacyKey(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;

}

void _ToChecksumAddress(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for ToChecksumAddress")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'address'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = ToChecksumAddress(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;

}

void _Logout(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();

	if (args.Length() != 0) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for Logout")));
		return;
	}

	// Check the argument types




	// Call exported Go function, which returns a C string
	char *c = Logout();

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _AcceptTerms(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();

	if (args.Length() != 0) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for AcceptTerms")));
		return;
	}

	// Check the argument types

	// Call exported Go function, which returns a C string
	char *c = AcceptTerms();

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;
}

void _HashMessage(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for HashMessage")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'message'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = HashMessage(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _ResetChainData(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();

	if (args.Length() != 0) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for ResetChainData")));
		return;
	}

	// Check the argument types




	// Call exported Go function, which returns a C string
	char *c = ResetChainData();

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _SaveAccountAndLogin(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 5) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for SaveAccountAndLogin")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'accountData'")));
		return;
	}
	if (!args[1]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'password'")));
		return;
	}
	if (!args[2]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'settingsJSON'")));
		return;
	}
	if (!args[3]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'configJSON'")));
		return;
	}
	if (!args[4]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'subaccountData'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;
	String::Utf8Value arg1Obj(isolate, args[1]->ToString(context).ToLocalChecked());
	char *arg1 = *arg1Obj;
	String::Utf8Value arg2Obj(isolate, args[2]->ToString(context).ToLocalChecked());
	char *arg2 = *arg2Obj;
	String::Utf8Value arg3Obj(isolate, args[3]->ToString(context).ToLocalChecked());
	char *arg3 = *arg3Obj;
	String::Utf8Value arg4Obj(isolate, args[4]->ToString(context).ToLocalChecked());
	char *arg4 = *arg4Obj;

	// Call exported Go function, which returns a C string
	char *c = SaveAccountAndLogin(arg0, arg1, arg2, arg3, arg4);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;

}

void _CreateAccountAndLogin(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for SaveAccountAndLogin")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'settingsJSON'")));
		return;
	}

	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = CreateAccountAndLogin(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;

}

void _ValidateMnemonic(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for ValidateMnemonic")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'mnemonic'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = ValidateMnemonic(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;

}

void _MultiformatSerializePublicKey(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 2) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for MultiformatSerializePublicKey")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'key'")));
		return;
	}
	if (!args[1]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'outBase'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;
	String::Utf8Value arg1Obj(isolate, args[1]->ToString(context).ToLocalChecked());
	char *arg1 = *arg1Obj;

	// Call exported Go function, which returns a C string
	char *c = MultiformatSerializePublicKey(arg0, arg1);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}


void _SaveAccountAndLoginWithKeycard(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 6) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for SaveAccountAndLoginWithKeycard")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'accountData'")));
		return;
	}
	if (!args[1]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'password'")));
		return;
	}
	if (!args[2]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'settingsJSON'")));
		return;
	}
	if (!args[3]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'configJSON'")));
		return;
	}
	if (!args[4]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'subaccountData'")));
		return;
	}
	if (!args[5]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'keyHex'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;
	String::Utf8Value arg1Obj(isolate, args[1]->ToString(context).ToLocalChecked());
	char *arg1 = *arg1Obj;
	String::Utf8Value arg2Obj(isolate, args[2]->ToString(context).ToLocalChecked());
	char *arg2 = *arg2Obj;
	String::Utf8Value arg3Obj(isolate, args[3]->ToString(context).ToLocalChecked());
	char *arg3 = *arg3Obj;
	String::Utf8Value arg4Obj(isolate, args[4]->ToString(context).ToLocalChecked());
	char *arg4 = *arg4Obj;
	String::Utf8Value arg5Obj(isolate, args[5]->ToString(context).ToLocalChecked());
	char *arg5 = *arg5Obj;

	// Call exported Go function, which returns a C string
	char *c = SaveAccountAndLoginWithKeycard(arg0, arg1, arg2, arg3, arg4, arg5);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _LoginWithKeycard(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 4) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for LoginWithKeycard")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'accountData'")));
		return;
	}
	if (!args[1]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'password'")));
		return;
	}
	if (!args[2]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'keyHex'")));
		return;
	}
	if (!args[3]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'nodeConfigJSON'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;
	String::Utf8Value arg1Obj(isolate, args[1]->ToString(context).ToLocalChecked());
	char *arg1 = *arg1Obj;
	String::Utf8Value arg2Obj(isolate, args[2]->ToString(context).ToLocalChecked());
	char *arg2 = *arg2Obj;
	String::Utf8Value arg3Obj(isolate, args[3]->ToString(context).ToLocalChecked());
    char *arg3 = *arg3Obj;

	// Call exported Go function, which returns a C string
	char *c = LoginWithKeycard(arg0, arg1, arg2, arg3);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _MultiformatDeserializePublicKey(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 2) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for MultiformatDeserializePublicKey")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'key'")));
		return;
	}
	if (!args[1]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'outBase'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;
	String::Utf8Value arg1Obj(isolate, args[1]->ToString(context).ToLocalChecked());
	char *arg1 = *arg1Obj;

	// Call exported Go function, which returns a C string
	char *c = MultiformatDeserializePublicKey(arg0, arg1);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _Login(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 2) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for Login")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'accountData'")));
		return;
	}
	if (!args[1]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'password'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;
	String::Utf8Value arg1Obj(isolate, args[1]->ToString(context).ToLocalChecked());
	char *arg1 = *arg1Obj;

	// Call exported Go function, which returns a C string
	char *c = Login(arg0, arg1);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

Local<Function> runCallbackCB;
Local<Context> runCallbackContext;
Isolate* runCallbackIsolate;

Persistent<Function> r_call;

std::queue<std::string> q;

void run(char *json) {
  std::string str(json);
  q.push(str);
}

// Poll signals and process queue, one at a time
void _PollSignal(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for SetSignalEventCallback")));
		return;
	}


        v8::Local<v8::Function> func = v8::Local<v8::Function>::Cast(args[0]);
        if (!q.empty()) {
          const unsigned argc = 1;
          v8::Local<v8::Value> argv[argc] = {v8::String::NewFromUtf8(isolate, q.front().c_str()).ToLocalChecked()};
          v8::MaybeLocal<v8::Value> result = func->Call(isolate->GetCurrentContext(), v8::Null(isolate), argc, argv);
          if (result.IsEmpty()) {
            isolate->ThrowException(Exception::Error(
                String::NewFromUtf8Literal(isolate, "Error calling the callback function")));
            return;
          }
          q.pop();
        }
}

void _SetSignalEventCallback(const FunctionCallbackInfo<Value>& args) {
        SetSignalEventCallback((void *)&run);
}



void _StartCPUProfile(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for StartCPUProfile")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'dataDir'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = StartCPUProfile(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _OpenAccounts(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for OpenAccounts")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'datadir'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = OpenAccounts(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _ExtractGroupMembershipSignatures(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for ExtractGroupMembershipSignatures")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'signaturePairsStr'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = ExtractGroupMembershipSignatures(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;

}

void _CallPrivateRPC(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for CallPrivateRPC")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'inputJSON'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = CallPrivateRPC(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;

}

void _SendTransactionWithSignature(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 2) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for SendTransactionWithSignature")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'txArgsJSON'")));
		return;
	}
	if (!args[1]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'sigString'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;
	String::Utf8Value arg1Obj(isolate, args[1]->ToString(context).ToLocalChecked());
	char *arg1 = *arg1Obj;

	// Call exported Go function, which returns a C string
	char *c = SendTransactionWithSignature(arg0, arg1);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _WriteHeapProfile(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for WriteHeapProfile")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'dataDir'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = WriteHeapProfile(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _SignHash(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for SignHash")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'hexEncodedHash'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = SignHash(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _SignGroupMembership(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for SignGroupMembership")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'content'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = SignGroupMembership(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _CallRPC(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for CallRPC")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'inputJSON'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = CallRPC(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _SignMessage(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for SignMessage")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'rpcParams'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = SignMessage(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _SignTypedData(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 3) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for SignTypedData")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'data'")));
		return;
	}
	if (!args[1]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'address'")));
		return;
	}
	if (!args[2]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'password'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;
	String::Utf8Value arg1Obj(isolate, args[1]->ToString(context).ToLocalChecked());
	char *arg1 = *arg1Obj;
	String::Utf8Value arg2Obj(isolate, args[2]->ToString(context).ToLocalChecked());
	char *arg2 = *arg2Obj;

	// Call exported Go function, which returns a C string
	char *c = SignTypedData(arg0, arg1, arg2);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _SendTransaction(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 2) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for SendTransaction")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'txArgsJSON'")));
		return;
	}
	if (!args[1]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'password'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;
	String::Utf8Value arg1Obj(isolate, args[1]->ToString(context).ToLocalChecked());
	char *arg1 = *arg1Obj;

	// Call exported Go function, which returns a C string
	char *c = SendTransaction(arg0, arg1);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _AppStateChange(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for AppStateChange")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'state'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	AppStateChange(arg0);




}

void _ValidateNodeConfig(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for ValidateNodeConfig")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'configJSON'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = ValidateNodeConfig(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _HashTypedData(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for HashTypedData")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'data'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = HashTypedData(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _Recover(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for Recover")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'rpcParams'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = Recover(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;


}

void _HashTransaction(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for HashTransaction")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'txArgsJSON'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = HashTransaction(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;
}

void _ConnectionChange(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 2) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for ConnectionChange")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'typ'")));
		return;
	}
	if (!args[1]->IsNumber()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'expensive'")));
		return;
	}


	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;
	int arg1 = args[1]->Int32Value(context).ToChecked();

	// Call exported Go function, which returns a C string
	ConnectionChange(arg0, arg1);
}

void _RestoreAccountAndLogin(const FunctionCallbackInfo<Value>& args) {
	Isolate* isolate = args.GetIsolate();
        Local<Context> context = isolate->GetCurrentContext();

	if (args.Length() != 1) {
		// Throw an Error that is passed back to JavaScript
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong number of arguments for RestoreAccountAndLogin")));
		return;
	}

	// Check the argument types

	if (!args[0]->IsString()) {
		isolate->ThrowException(Exception::TypeError(
			String::NewFromUtf8Literal(isolate, "Wrong argument type for 'RestoreAccountAndLogin'")));
		return;
	}

	String::Utf8Value arg0Obj(isolate, args[0]->ToString(context).ToLocalChecked());
	char *arg0 = *arg0Obj;

	// Call exported Go function, which returns a C string
	char *c = RestoreAccountAndLogin(arg0);

	Local<String> ret = String::NewFromUtf8(isolate, c).ToLocalChecked();
	args.GetReturnValue().Set(ret);
	delete c;
}


void init(Local<Object> exports) {
	NODE_SET_METHOD(exports, "multiAccountGenerateAndDeriveAddresses", _MultiAccountGenerateAndDeriveAddresses);
	NODE_SET_METHOD(exports, "multiAccountImportPrivateKey", _MultiAccountImportPrivateKey);
	NODE_SET_METHOD(exports, "multiAccountLoadAccount", _MultiAccountLoadAccount);
	NODE_SET_METHOD(exports, "multiAccountReset", _MultiAccountReset);
	NODE_SET_METHOD(exports, "multiAccountDeriveAddresses", _MultiAccountDeriveAddresses);
	NODE_SET_METHOD(exports, "multiAccountImportMnemonic", _MultiAccountImportMnemonic);
	NODE_SET_METHOD(exports, "multiAccountGenerate", _MultiAccountGenerate);
	NODE_SET_METHOD(exports, "multiAccountStoreDerivedAccounts", _MultiAccountStoreDerivedAccounts);
	NODE_SET_METHOD(exports, "multiAccountStoreAccount", _MultiAccountStoreAccount);
	NODE_SET_METHOD(exports, "initKeystore", _InitKeystore);
	NODE_SET_METHOD(exports, "initializeApplication", _InitializeApplication);
	NODE_SET_METHOD(exports, "acceptTerms", _AcceptTerms);
	NODE_SET_METHOD(exports, "fleets", _Fleets);
	NODE_SET_METHOD(exports, "stopCPUProfiling", _StopCPUProfiling);
	NODE_SET_METHOD(exports, "decodeParameters", _DecodeParameters);
	NODE_SET_METHOD(exports, "hexToNumber", _HexToNumber);
	NODE_SET_METHOD(exports, "numberToHex", _NumberToHex);
	NODE_SET_METHOD(exports, "checkAddressChecksum", _CheckAddressChecksum);
	NODE_SET_METHOD(exports, "isAddress", _IsAddress);
	NODE_SET_METHOD(exports, "sha3", _Sha3);
	NODE_SET_METHOD(exports, "serializeLegacyKey", _SerializeLegacyKey);
	NODE_SET_METHOD(exports, "toChecksumAddress", _ToChecksumAddress);
	NODE_SET_METHOD(exports, "logout", _Logout);
	NODE_SET_METHOD(exports, "hashMessage", _HashMessage);
	NODE_SET_METHOD(exports, "resetChainData", _ResetChainData);
	NODE_SET_METHOD(exports, "saveAccountAndLogin", _SaveAccountAndLogin);
	NODE_SET_METHOD(exports, "createAccountAndLogin", _CreateAccountAndLogin);
	NODE_SET_METHOD(exports, "validateMnemonic", _ValidateMnemonic);
	NODE_SET_METHOD(exports, "multiformatSerializePublicKey", _MultiformatSerializePublicKey);
	NODE_SET_METHOD(exports, "loginWithKeycard", _LoginWithKeycard);
	NODE_SET_METHOD(exports, "multiformatDeserializePublicKey", _MultiformatDeserializePublicKey);
	NODE_SET_METHOD(exports, "login", _Login);
	NODE_SET_METHOD(exports, "startCPUProfile", _StartCPUProfile);
	NODE_SET_METHOD(exports, "openAccounts", _OpenAccounts);
	NODE_SET_METHOD(exports, "extractGroupMembershipSignatures", _ExtractGroupMembershipSignatures);
	NODE_SET_METHOD(exports, "callPrivateRPC", _CallPrivateRPC);
	NODE_SET_METHOD(exports, "sendTransactionWithSignature", _SendTransactionWithSignature);
	NODE_SET_METHOD(exports, "writeHeapProfile", _WriteHeapProfile);
	NODE_SET_METHOD(exports, "signHash", _SignHash);
	NODE_SET_METHOD(exports, "signGroupMembership", _SignGroupMembership);
	NODE_SET_METHOD(exports, "callRPC", _CallRPC);
	NODE_SET_METHOD(exports, "signMessage", _SignMessage);
	NODE_SET_METHOD(exports, "signTypedData", _SignTypedData);
	NODE_SET_METHOD(exports, "sendTransaction", _SendTransaction);
	NODE_SET_METHOD(exports, "appStateChange", _AppStateChange);
        NODE_SET_METHOD(exports, "setSignalEventCallback", _SetSignalEventCallback);
	NODE_SET_METHOD(exports, "validateNodeConfig", _ValidateNodeConfig);
	NODE_SET_METHOD(exports, "hashTypedData", _HashTypedData);
	NODE_SET_METHOD(exports, "recover", _Recover);
	NODE_SET_METHOD(exports, "hashTransaction", _HashTransaction);
	NODE_SET_METHOD(exports, "connectionChange", _ConnectionChange);
	NODE_SET_METHOD(exports, "pollSignal", _PollSignal);
	NODE_SET_METHOD(exports, "restoreAccountAndLogin", _RestoreAccountAndLogin);
}

NODE_MODULE(NODE_GYP_MODULE_NAME, init)

}  // namespace status
