## Getting Started

- [Starting Guide](starting-guide.md)
- [IDE Setup](ide-setup.md)

## Development Process

- [Coding guidelines](new-guidelines.md)
- [Layered architecture](architecture-layers.md)
- [UI components coding guidelines](ui-guidelines.md)
- [Release Checklist](release-checklist.md)
- [Release Guide](release-guide.md)
- [Merging PR process](merging-pr-process.md)
- [PR Review Policy](pr-review-policy.md)
- [Working on PR together with QA team](pipeline_process.md)
- [Debugging](debugging.md)
- [Patching](patching.md)
- [Creating a pixel perfect UI](pixel-perfection.md)
- [Contributing to status-go](status-go-changes.md)
- [Status Backend Server](use-status-backend-server.md)
- [Malli schemas (recorded demo)](https://www.youtube.com/watch?v=SlRio70aYVI) ([slides](files/forging-code-with-schemas-sep-2023-slides.pdf))

## Testing

- [Overview](tests/tests-overview.md)
- [How to run local tests](tests/how-to-run-local-tests.md)
- [End-to-end tests (e2e) overview](tests/how-to-launch-e2e.md)
- [Component tests (jest) overview](tests/component-tests-overview.md)

## Project details

- [status-go introduction (recorded meeting)](https://drive.google.com/file/d/1B7TljmTZ8fHkqJH8ChU1Cp4FGDFM03gq/view)
- [re-frame usage (recorded meeting)](https://drive.google.com/file/d/1qv_E0CEGzQpu_zGXD0gCTU5EvhC2k8Jy/view)
- [status app functionality demo](https://drive.google.com/file/u/0/d/1PmwsMLTLDNNIdv5_6wvMOwoj2PfT50c6/view)

## Misc

- [Importing assets from Figma into project](import-assets.md)
- [Updating Status APK builds for the F-Droid Android application catalogue](fdroid.md)
- [Troubleshooting for known errors](troubleshooting.md)

## Outdated:

- [Old guidelines](codebase-structure-and-guidelines.md)
- [Post mortem analysis](post-mortem.md)
