package gq.kirmanak.mealient.shopping_lists.network

import gq.kirmanak.mealient.datasource.models.CreateShoppingListItemRequest
import gq.kirmanak.mealient.datasource.models.CreateShoppingListRequest
import gq.kirmanak.mealient.datasource.models.GetFoodResponse
import gq.kirmanak.mealient.datasource.models.GetShoppingListItemResponse
import gq.kirmanak.mealient.datasource.models.GetShoppingListResponse
import gq.kirmanak.mealient.datasource.models.GetShoppingListsSummaryResponse
import gq.kirmanak.mealient.datasource.models.GetUnitResponse

interface ShoppingListsDataSource {

    suspend fun getAllShoppingLists(): List<GetShoppingListsSummaryResponse>

    suspend fun getShoppingList(id: String): GetShoppingListResponse

    suspend fun deleteShoppingListItem(id: String)

    suspend fun updateShoppingListItem(item: GetShoppingListItemResponse)

    suspend fun getFoods(): List<GetFoodResponse>

    suspend fun getUnits(): List<GetUnitResponse>

    suspend fun addShoppingListItem(item: CreateShoppingListItemRequest)

    suspend fun addShoppingList(request: CreateShoppingListRequest)

    suspend fun deleteShoppingList(id: String)

    suspend fun updateShoppingListName(id: String, name: String)
}