package godau.fynn.moodledirect.view

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material.Checkbox
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import godau.fynn.moodledirect.module.link.ChoiceLink
import godau.fynn.moodledirect.module.link.ModuleLink

@Composable
fun SupportedModuleRow(module: ModuleLink, isSupported: Boolean) = Row(Modifier.padding(16.dp)) {

    Image(
        painter = painterResource(id = module.icon),
        contentDescription = null,
        modifier = Modifier
            .size(32.dp)
            .align(Alignment.Top),
        alpha = if (isSupported) 1f else 0.5f
    )

    Column(
        Modifier
            .padding(start = 16.dp, end = 16.dp)
            .align(Alignment.CenterVertically)
            .weight(1f)
    ) {
        Text(text = stringResource(id = module.name), style = MaterialTheme.typography.body1)

        if (!isSupported) {
            module.requirementText?.let {
                Text(text = stringResource(id = it), style = MaterialTheme.typography.body2)
            }
        }
    }

    Checkbox(
        checked = isSupported,
        onCheckedChange = {},
        enabled = false,
        modifier = Modifier
            .align(Alignment.CenterVertically)
            .height(32.dp)
    )
}

@Preview
@Composable
fun ChoiceSupportedModuleRow() {
    SupportedModuleRow(module = ChoiceLink, isSupported = false)
}