package godau.fynn.moodledirect.view

import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.material.Icon
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.alpha
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.colorResource
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import godau.fynn.moodledirect.R
import godau.fynn.moodledirect.model.database.Module
import godau.fynn.moodledirect.util.TextUtil

@Composable
// TODO: Remove "show more" and "…" items
fun RestrictionRow(module: Module) =
    RestrictionRow(
        TextUtil.fromHtml(module.notAvailableReason, LocalContext.current).toString(),
        module.hierarchyDepth
    )

@Composable
fun RestrictionRow(reasonText: String, hierarchyDepth: Int) {
    Row(
        Modifier
            .padding(bottom = 8.dp, start = ((hierarchyDepth * HIERARCHY_INTENSITY + 1) * 16).dp, end = 16.dp)
            .fillMaxWidth()
    ) {
        Icon(
            painter = painterResource(id = R.drawable.ic_information),
            contentDescription = null,
            modifier = Modifier
                .width(32.dp)
                .height(16.dp)
                .padding(start = 16.dp)
                .align(Alignment.CenterVertically),
            tint = colorResource(
                id = R.color.colorAccent
            )
        )

        Text(
            text = reasonText,
            modifier = Modifier
                .padding(start = 16.dp)
                .fillMaxWidth()
                .align(Alignment.CenterVertically)
                .alpha(0.5f),
            style = MaterialTheme.typography.body2
        )
    }
}

@Composable
@Preview
fun PreviewRestrictionRow() {
    RestrictionRow(reasonText = "Not available unless: Your Institution is University of Würzburg", 1)
}