package godau.fynn.moodledirect.view

import android.annotation.SuppressLint
import android.text.SpannableStringBuilder
import android.util.DisplayMetrics
import androidx.compose.foundation.layout.BoxWithConstraints
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.toArgb
import androidx.compose.ui.platform.LocalConfiguration
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.platform.LocalDensity
import androidx.compose.ui.unit.dp
import androidx.compose.ui.viewinterop.AndroidView
import godau.fynn.moodledirect.model.database.Module
import godau.fynn.moodledirect.util.MyApplication
import godau.fynn.moodledirect.util.TextUtil.fromHtml

@Composable
fun ModuleDescriptionText(module: Module, modifier: Modifier = Modifier) =
    module.getDescription()?.let {
        FillImageLoaderText(
            html = it,
            fullUrls = module.fileList?.map { it.url } ?: listOf(),
            modifier = modifier
        )
    }

@SuppressLint("UnusedBoxWithConstraintsScope")
@Composable
fun FillImageLoaderText(html: String, fullUrls: List<String>, color: Color? = null, modifier: Modifier = Modifier) =
    BoxWithConstraints(modifier.fillMaxWidth()) {
        val content = fromHtml(html, LocalContext.current,
            with(LocalDensity.current) { maxWidth.roundToPx() })
        if (content.isNotBlank()) {
            ImageLoaderText(
                content = content,
                color = color,
                fullUrls = fullUrls
            )
        }
    }

@Composable
fun ImageLoaderText(content: SpannableStringBuilder, color: Color? = null, fullUrls: List<String>) {
    val metrics = LocalConfiguration.current.let {
        DisplayMetrics().apply {
            widthPixels = with(LocalDensity.current) {
                it.screenWidthDp.dp.roundToPx()
            }
            heightPixels = with(LocalDensity.current) {
                it.screenHeightDp.dp.roundToPx()
            }
        }
    }
    AndroidView(factory = {
        ImageLoaderTextView(it)
    }, onReset = {
    }) { text ->
        text.setText(
            content,
            fullUrls,
            MyApplication.moodle().dispatch.getCommonAsset(),
            metrics
        )
        text.setTextIsSelectable(true)
        color?.let { text.setTextColor(it.toArgb()) }
    }
}