package godau.fynn.moodledirect.view

import android.text.format.DateUtils
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.alpha
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import godau.fynn.moodledirect.R
import godau.fynn.moodledirect.model.database.Course
import godau.fynn.moodledirect.util.TextUtil

@Composable
fun CourseInformationView(course: Course) = Column(Modifier.padding(8.dp).fillMaxSize()) {

    val padding = Modifier.padding(8.dp)

    if (course.summary.isNotBlank()) {
        FillImageLoaderText(course.summary, emptyList(), MaterialTheme.colors.onBackground, padding)
    }

    @Composable
    fun formatRelative(epochSeconds: Long) = DateUtils.getRelativeTimeSpanString(
        LocalContext.current,
        epochSeconds * 1000,
        true
    )

    // Render duration string
    val start =
        if (course.timeStart * 1000 > System.currentTimeMillis()) { // start is in future
            stringResource(R.string.course_duration_start_future, formatRelative(course.timeStart))
        } else {
            stringResource(R.string.course_duration_start_past, formatRelative(course.timeStart))
        }

    val end: String? =
        if (course.timeEnd > 0 && course.timeEnd * 1000 > System.currentTimeMillis()) {
            // end is set and in future
            stringResource(R.string.course_duration_end_future, formatRelative(course.timeEnd))
        } else if (course.timeEnd > 0) {
            // end is set and already in the past
            stringResource(R.string.course_duration_end_past, formatRelative(course.timeEnd))
        } else null

    Text(TextUtil.combine(", ", start, end), padding.alpha(0.5f))

    Text(stringResource(R.string.course_participants, course.enrolledUserCount), padding.alpha(0.5f))
}