package godau.fynn.moodledirect.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import godau.fynn.moodledirect.activity.login.LoginActivity;
import godau.fynn.moodledirect.data.persistence.PreferenceHelper;
import godau.fynn.moodledirect.data.persistence.UserAccount;
import godau.fynn.moodledirect.network.APIClient;

/**
 * Created by Harshit Agarwal on 24-11-2017.
 */

public class UserUtils {
    public static void logout(Context context) {
        new PreferenceHelper(context).logout();

        // TODO delete database

        APIClient.clearMoodleInstance();
        Constants.API_URL = "";
        Constants.TOKEN = null;
    }

    public static void startLoginActivityForCurrentInstance(Context context) {

        if (context instanceof Activity) {
            // Fill in moodle instance URL in login screen
            Intent intent = new Intent(context, LoginActivity.class);
            intent.setData(Uri.parse("moodlemobile://" + Constants.API_URL));
            context.startActivity(intent);
        }
    }

    public static String resolveUrl(String url, UserAccount userAccount) {
        if (url == null) return null;
        return url
                .replace("/webservice/pluginfile.php/", "/pluginfile.php/")
                .replace("/pluginfile.php/",
                        "/tokenpluginfile.php/" + userAccount.getFilePrivateAccessKey() + "/"
                );
    }
}
