package godau.fynn.moodledirect.util

import android.content.Context
import android.net.Uri
import android.util.Log
import android.view.View
import androidx.browser.customtabs.CustomTabsIntent
import godau.fynn.moodledirect.R
import godau.fynn.moodledirect.data.persistence.PreferenceHelper
import godau.fynn.moodledirect.network.NetworkStateReceiver
import godau.fynn.moodledirect.util.ExceptionHandler.tryAndThenThread

/**
 * Provides UI components for autologin
 */
object AutoLoginHelper {

    @JvmStatic
    fun openWithAutoLogin(context: Context, drawContext: View?, url: String) {
        openWithAutoLogin(context, {}, url)
    }

    @JvmStatic
    fun openWithAutoLogin(context: Context, setStatus: (String?) -> Unit, url: String) {
        val intent = CustomTabsIntent.Builder()
            .build()
        val preferences = PreferenceHelper(context)
        val userAccount = preferences.activeAccount
        if (userAccount.hasPrivateToken() && userAccount.lastAutoLoginTime + userAccount.autoLoginCooldown < System.currentTimeMillis() && preferences.isAutoLoginEnabled
            && !NetworkStateReceiver.getOfflineStatus()
        ) {
            setStatus(context.getString(R.string.autologin_in_progress))
            userAccount.recordAutoLogin()

            context.tryAndThenThread<String>(
                {
                    MyApplication.moodle().dispatch.getTool().getAutoLoginUrl(url)
                },
                { autoUrl: String? ->
                    setStatus(null)
                    intent.launchUrl(context, Uri.parse(autoUrl))
                },
                { otherwise: Exception? ->
                    setStatus(null)
                    intent.launchUrl(context, Uri.parse(url))
                }
            )
        } else {
            Log.d(
                AutoLoginHelper::class.java.getSimpleName(),
                "Autlogin conditions not fulfilled. Has " + (if (userAccount.hasPrivateToken()) "" else "no ") + "private token, " +
                        "cooldown ends in " + (userAccount.lastAutoLoginTime + userAccount.autoLoginCooldown - System.currentTimeMillis()) + " millis, " +
                        "autologin is " + (if (preferences.isAutoLoginEnabled) "" else "not ") + "enabled and " +
                        "offline mode is " + if (NetworkStateReceiver.getOfflineStatus()) "enabled." else "disabled."
            )
            // Do not perform autologin
            intent.launchUrl(context, Uri.parse(url))
        }
    }
}
