package godau.fynn.moodledirect.module.link

import androidx.annotation.StringRes
import androidx.fragment.app.FragmentActivity
import godau.fynn.moodledirect.R
import godau.fynn.moodledirect.model.database.Course
import godau.fynn.moodledirect.model.database.Module
import godau.fynn.moodledirect.util.ExceptionHandler.tryAndThenThread
import godau.fynn.moodledirect.util.MyApplication

data object ZoomLink : ModuleLink() {
    override fun onOpen(
        module: Module,
        course: Course,
        context: FragmentActivity,
        setStatus: (String?) -> Unit
    ) {
        setStatus(
            context.getString(R.string.zoom_progress_downloading_link)
        )
        context.tryAndThenThread(
            { MyApplication.moodle().dispatch.getZoom().getConferenceLink(module.id) },
            { link: String? ->
                openWebsite(
                    context,
                    link
                ) // No automagic login for external URL
                setStatus(null)
            },
            { otherwise: Exception? -> setStatus(null) },
        )
    }

    override fun requiresCalls(): Array<String> {
        return arrayOf("mod_zoom_grade_item_update")
    }

    override val icon: Int
        get() = R.drawable.ic_conference
    override val name: Int
        get() = R.string.zoom

    @get:StringRes
    override val requirementText: Int
        get() = R.string.supported_modules_requirement_zoom
}
