package godau.fynn.moodledirect.module.link

import androidx.fragment.app.FragmentActivity
import godau.fynn.moodledirect.R
import godau.fynn.moodledirect.model.database.Course
import godau.fynn.moodledirect.model.database.Module

data object UrlLink : ModuleLink() {
    override fun onOpen(
        module: Module,
        course: Course,
        context: FragmentActivity,
        setStatus: (String?) -> Unit
    ) {
        if (module.fileList.size > 0 && module.fileList[0].url.isNotEmpty()) {
            // No automagic login for external URL
            openWebsite(context, module.fileList[0].url)
        }
    }

    override val icon: Int
        get() = R.drawable.web
    override val name: Int
        get() = R.string.supported_modules_url
}
