package godau.fynn.moodledirect.module.link

import android.widget.Toast
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import godau.fynn.moodledirect.R
import godau.fynn.moodledirect.activity.fragment.module.PageFragment
import godau.fynn.moodledirect.model.database.Course
import godau.fynn.moodledirect.model.database.Module

data object PageLink : ModuleLink() {
    override fun onOpen(
        module: Module,
        course: Course,
        context: FragmentActivity,
        setStatus: (String?) -> Unit
    ) {
        if (module.contents == null || module.contents.size == 0) {
            Toast.makeText(context, R.string.page_not_available, Toast.LENGTH_SHORT).show()
            return
        }
        val files = arrayOfNulls<String>(module.fileList.size)
        for (i in files.indices) {
            files[i] = module.fileList[i].url
        }
        val pageFragment: Fragment = PageFragment.newInstance(files)
        showFragment(context!!, pageFragment, "Page")
    }

    override val icon: Int
        get() = R.drawable.page
    override val name: Int
        get() = R.string.supported_modules_page
}
