package godau.fynn.moodledirect.module.link

import androidx.annotation.StringRes
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import godau.fynn.moodledirect.R
import godau.fynn.moodledirect.activity.fragment.module.forum.ForumFragment
import godau.fynn.moodledirect.model.database.Course
import godau.fynn.moodledirect.model.database.Module
import godau.fynn.moodledirect.util.Constants

data object ForumLink : ModuleLink() {
    override fun onOpen(
        module: Module,
        course: Course,
        context: FragmentActivity,
        setStatus: (String?) -> Unit
    ) {
        val forumFragment: Fragment =
            ForumFragment.newInstance(module.id, module.getInstance(), course.shortname)
        showFragment(context!!, forumFragment, "Forum")
    }

    override fun requiresCalls(): Array<String> {
        // From Moodle 3.7
        return arrayOf(
            "mod_forum_get_forum_discussions",
            "mod_forum_get_discussion_posts"
        )
    }

    override val icon: Int
        get() = R.drawable.forum
    override val name: Int
        get() = R.string.supported_modules_forum

    @get:StringRes
    override val requirementText: Int
        get() = R.string.supported_modules_requirement_moodle_37

    @JvmStatic
    fun getForumUrl(forumId: Int): String {
        return Constants.API_URL + "mod/forum/view.php?id=" + forumId
    }

    @JvmStatic
    fun getDiscussionUrl(discussionId: Int): String {
        return Constants.API_URL + "mod/forum/discuss.php?d=" + discussionId
    }
}
