package godau.fynn.moodledirect.module.link

import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import godau.fynn.moodledirect.R
import godau.fynn.moodledirect.activity.fragment.module.FolderModuleFragment
import godau.fynn.moodledirect.model.database.Course
import godau.fynn.moodledirect.model.database.Module

data object FolderLink : ModuleLink() {
    override fun onOpen(
        module: Module,
        course: Course,
        context: FragmentActivity,
        setStatus: (String?) -> Unit
    ) {
        val folderModuleFragment: Fragment = FolderModuleFragment.newInstance(module.getInstance())
        showFragment(context!!, folderModuleFragment, "Folder")
    }

    override val icon: Int
        get() = R.drawable.folder
    override val name: Int
        get() = R.string.folder
}
