package godau.fynn.moodledirect.module.link

import androidx.annotation.StringRes
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import godau.fynn.moodledirect.R
import godau.fynn.moodledirect.activity.fragment.module.choice.ChoiceFragmentFactory
import godau.fynn.moodledirect.model.database.Course
import godau.fynn.moodledirect.model.database.Module

data object ChoiceLink : ModuleLink() {
    override fun onOpen(
        module: Module,
        course: Course,
        context: FragmentActivity,
        setStatus: (String?) -> Unit
    ) {
        val choiceFragment: Fragment =
            ChoiceFragmentFactory.makeChoiceFragment(module.getInstance(), module.courseId)
        showFragment(context!!, choiceFragment, "Choice")
    }

    override fun requiresCalls(): Array<String> {
        // Available from Moodle 3.0
        return arrayOf(
            "mod_choice_get_choice_options",
            "mod_choice_submit_choice_response",
            "mod_choice_get_choices_by_courses",
            "mod_choice_delete_choice_responses"
        )
    }

    override val icon: Int
        get() = R.drawable.ic_poll
    override val name: Int
        get() = R.string.choice

    @get:StringRes
    override val requirementText: Int
        get() = R.string.supported_modules_requirement_moodle_30
}
