package godau.fynn.moodledirect.module.link

import androidx.annotation.StringRes
import androidx.fragment.app.FragmentActivity
import godau.fynn.moodledirect.R
import godau.fynn.moodledirect.activity.fragment.module.AssignmentFragment
import godau.fynn.moodledirect.model.database.Course
import godau.fynn.moodledirect.model.database.Module

data object AssignmentLink : ModuleLink() {
    override fun onOpen(
        module: Module,
        course: Course,
        context: FragmentActivity,
        setStatus: (String?) -> Unit
    ) {
        showFragment(
            context!!,
            AssignmentFragment.newInstance(module),
            null
        )
    }

    override val icon: Int
        get() = R.drawable.book
    override val name: Int
        get() = R.string.assignment

    override fun requiresCalls(): Array<String>? {
        return arrayOf(
            "mod_assign_get_submission_status"
        )
    }

    @get:StringRes
    override val requirementText: Int?
        get() = R.string.supported_modules_requirement_moodle_31
}
