package godau.fynn.moodledirect.activity.fragment

import android.os.Bundle
import android.text.format.DateUtils
import android.text.method.LinkMovementMethod
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.compose.runtime.getValue
import androidx.compose.runtime.key
import androidx.compose.runtime.mutableStateListOf
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.compose.ui.platform.ComposeView
import androidx.fragment.app.Fragment
import godau.fynn.moodledirect.R
import godau.fynn.moodledirect.model.database.Course
import godau.fynn.moodledirect.util.ExceptionHandler.ExceptionableSupplier
import godau.fynn.moodledirect.util.ExceptionHandler.tryAndThenThread
import godau.fynn.moodledirect.util.MyApplication
import godau.fynn.moodledirect.util.TextUtil
import godau.fynn.moodledirect.view.CourseInformationView
import godau.fynn.moodledirect.view.ImageLoaderTextView

class CourseInformationFragment : Fragment() {

    var course by mutableStateOf<Course?>(null)

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ) = ComposeView(requireContext()).apply {
        setContent {
            course?.let {
                CourseInformationView(it)
            }
        }
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        val courseId = requireArguments().getInt(KEY_COURSE_ID)

        tryAndThenThread(
            { MyApplication.moodle().forceOffline().core.getCourse(courseId) },
            { course = it },
            requireContext()
        )
    }

    companion object {
        private const val KEY_COURSE_ID = "id" // COURSE on T9

        fun newInstance(courseId: Int): CourseInformationFragment {
            val fragment = CourseInformationFragment()
            val arguments = Bundle()
            arguments.putInt(KEY_COURSE_ID, courseId)
            fragment.arguments = arguments
            return fragment
        }
    }
}
