package godau.fynn.moodledirect.activity

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.material.Icon
import androidx.compose.material.IconButton
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Text
import androidx.compose.material.TopAppBar
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.ArrowBack
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import godau.fynn.moodledirect.R
import godau.fynn.moodledirect.data.persistence.PreferenceHelper
import godau.fynn.moodledirect.module.link.ModuleLink
import godau.fynn.moodledirect.view.DawdleTheme
import godau.fynn.moodledirect.view.SupportedModuleRow

class SupportedModulesActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        // TODO: Dark theme
        super.onCreate(savedInstanceState)
        val account = PreferenceHelper(this).activeAccount
        setContent {
            DawdleTheme {
                Column {
                    TopAppBar(
                        title = { Text(text = stringResource(id = R.string.settings_instance_supported_modules)) },
                        backgroundColor = MaterialTheme.colors.primary,
                        navigationIcon = {
                            IconButton(onClick = { finish() }) {
                                Icon(
                                    imageVector = Icons.AutoMirrored.Filled.ArrowBack,
                                    contentDescription = stringResource(id = R.string._navigate_backward)
                                )
                            }
                        })

                    LazyColumn(contentPadding = PaddingValues(8.dp)) {

                        item {
                            Text(
                                text = stringResource(id = R.string.supported_modules_explanation),
                                modifier = Modifier.padding(8.dp),
                                style = MaterialTheme.typography.body2
                            )
                        }

                        ModuleLink.links
                            .sortedBy { o: ModuleLink -> o.javaClass.getSimpleName() }
                            .let { items(it) { module ->
                                SupportedModuleRow(module = module, isSupported = module.isSupported(account))
                            } }

                        item {
                            Text(
                                text = stringResource(id = R.string.supported_modules_coming_soon),
                                modifier = Modifier.padding(8.dp),
                                style = MaterialTheme.typography.body2
                            )
                        }
                    }
                }
            }
        }
    }
}
