# TrinaGrid Documentation

Welcome to the official documentation for TrinaGrid, a powerful data grid for Flutter.

## Getting Started

- [Installation](getting-started/installation.md)
- [Basic Usage](getting-started/basic-usage.md)
- [Configuration](getting-started/configuration.md)

## Migration

- [Migrating from PlutoGrid](migration/pluto-to-trina.md)
- [Migration Tool Reference](migration/migration-tool.md)
- [Dynamic Row Heights Migration](migration/dynamic-row-heights-migration.md)

## Features

### Column Features

- [Column Types](features/column-types.md)
- [Column Freezing](features/column-freezing.md)
- [Column Resizing](features/column-resizing.md)
- [Column Moving](features/column-moving.md)
- [Column Hiding](features/column-hiding.md)
- [Column Sorting](features/column-sorting.md)
- [Column Filtering](features/column-filtering.md)
  - [Multi-Items Filter](features/column-filtering.md#multi-items-filter-multi-linecomma-separated)
- [Column Groups](features/column-groups.md)
- [Column Renderers](features/column-renderer.md)
- [Column Title Renderer](features/column-title-renderer.md)
- [Column Footer](features/column-footer.md)
- [Column Viewport Visibility](features/column-visibility.md)

### Row Features

- [Row Selection](features/row-selection.md)
- [Row Moving](features/row-moving.md)
- [Row Coloring](features/row-color.md)
- [Row Wrapper](features/row-wrapper.md)
- [Row Checking](features/row-checking.md)
- [Row Groups](features/row-groups.md)
- [Frozen Rows](features/frozen-rows.md)
- [Dynamic Row Heights](features/dynamic-row-heights.md)

### Cell Features

- [Cell Selection](features/cell-selection.md)
- [Cell Editing](features/cell-editing.md)
- [Cell Navigation Validation](features/cell-navigation-validation.md)
- [Cell Renderers](features/cell-renderer.md)
- [Cell Validation](features/cell-validation.md)
- [Cell Value Change Handling](features/cell_value_change_handling.md)

### Data Management

- [Pagination Overview](features/pagination.md)
  - [Client-Side Pagination](features/pagination-client.md)
  - [Lazy Pagination (Server-Side)](features/lazy-pagination.md)
- [Infinite Scrolling](features/infinite-scrolling.md)
- [Lazy Loading](features/lazy-loading.md)
- [Copy & Paste](features/copy-paste.md)
- [Export](features/export.md)

### UI Customization

- [Themes](features/themes.md)
- [Custom Styling](features/custom-styling.md)
- [Loading Options](features/loading-options.md)
- [Scrollbars](features/scrollbars.md)
- [RTL Support](features/rtl-support.md)

### Other Features

- [Keyboard Navigation](features/keyboard-navigation.md)
- [Context Menus](features/context-menus.md)
- [Dual Grid Mode](features/dual-grid-mode.md)
- [Popup Mode](features/popup-mode.md)
- [Change Tracking](features/change-tracking.md)

## Examples

- [Basic Grid](examples/basic-grid.md)
- [Custom Renderers](examples/custom-renderers.md)
- [Filtering and Sorting](examples/filtering-sorting.md)
- [Pagination](examples/pagination.md)
- [Row and Cell Selection](examples/selection.md)
- [Dynamic Row Heights](examples/dynamic-row-heights.md)

## API Reference

- [TrinaGrid](api/trina-grid.md) - Main grid widget
- [TrinaColumn](api/trina-column.md) - Column definition
- [TrinaRow](api/trina-row.md) - Row data model
- [TrinaCell](api/trina-cell.md) - Cell data model
- [TrinaGridStateManager](api/trina-grid-state-manager.md) - State management

## Contributing

- [Contributors](contributing/contributors.md) - Meet our amazing contributors
- [How to Contribute](contributing/how-to-contribute.md) - Guidelines for contributing
- [Code of Conduct](contributing/code-of-conduct.md) - Community standards

## Release Notes

- [Changelog](changelog.md)
