import 'package:flutter/material.dart';
import 'package:io_file_picker_ui/src/fs_entities.dart';
import 'package:io_file_picker_ui/src/widgets/directory_list_tile.dart';
import 'package:io_file_picker_ui/src/widgets/file_list_tile.dart';

class LinkListTile extends StatelessWidget {
  final LinkEntityWrapper linkEntity;
  final void Function()? onTap;
  final void Function()? onIconTap;
  final bool enabled;
  final bool selected;
  const LinkListTile({
    super.key,
    required this.linkEntity,
    this.onTap,
    this.onIconTap,
    this.enabled = true,
    this.selected = false,
  });

  @override
  Widget build(BuildContext context) {
    final resolvedEntity = linkEntity.resolvedEntity;
    switch (resolvedEntity) {
      case FileEntityWrapper():
        return FileListTile(
          fileEntity: resolvedEntity,
          enabled: enabled,
          onIconTap: onIconTap,
          onTap: onTap,
          selected: selected,
          showLinkTo: resolvedEntity.file.path,
        );
      case DirectoryEntityWrapper():
        return DirectoryListTile(
          directoryEntity: resolvedEntity,
          enabled: enabled,
          onIconTap: onIconTap,
          onTap: onTap,
          selected: selected,
          showLinkTo: resolvedEntity.directory.path,
        );
      case LinkEntityWrapper():
        return LinkListTile(
          linkEntity: linkEntity,
          enabled: enabled,
          onIconTap: onIconTap,
          onTap: onTap,
          selected: selected,
        );
    }
  }
}
