import 'package:flutter/material.dart';
import 'package:io_file_picker_ui/src/fs_entities.dart';

class FileListTile extends StatelessWidget {
  final FileEntityWrapper fileEntity;
  final void Function()? onTap;
  final void Function()? onIconTap;
  final bool enabled;
  final String? showLinkTo;
  final bool selected;
  const FileListTile({
    super.key,
    required this.fileEntity,
    this.onTap,
    this.onIconTap,
    this.enabled = true,
    this.showLinkTo,
    this.selected = false,
  });

  @override
  Widget build(BuildContext context) {
    final iconToShow = switch (fileEntity.fileType) {
      FileType.audio => Icons.audio_file,
      FileType.video => Icons.video_file,
      FileType.image => Icons.image,
      FileType.plainText => Icons.subject,
      FileType.archive => Icons.archive,
      FileType.document => Icons.edit_document,
      FileType.unknown => Icons.description,
    };
    return ListTile(
      leading: IconButton(icon: Icon(iconToShow), onPressed: onIconTap),
      title: Text(
          "${fileEntity.name}${(showLinkTo != null) ? ' → $showLinkTo' : ''}"),
      onTap: onTap,
      enabled: enabled,
      selected: selected,
      trailing: selected ? Icon(Icons.check) : null,
    );
  }
}
