import 'package:flutter/material.dart';
import 'package:io_file_picker_ui/src/fs_entities.dart';

class DirectoryListTile extends StatelessWidget {
  final DirectoryEntityWrapper directoryEntity;
  final void Function()? onTap;
  final void Function()? onLongPress;
  final void Function()? onIconTap;
  final bool enabled;
  final String? showLinkTo;
  final bool selected;
  const DirectoryListTile({
    super.key,
    required this.directoryEntity,
    this.onTap,
    this.onLongPress,
    this.onIconTap,
    this.enabled = true,
    this.showLinkTo,
    this.selected = false,
  });

  @override
  Widget build(BuildContext context) {
    return ListTile(
      leading: IconButton(icon: Icon(Icons.folder), onPressed: onIconTap),
      title: Text(
          "${directoryEntity.name}${(showLinkTo != null) ? ' → $showLinkTo' : ''}"),
      subtitle: Text(
        "${directoryEntity.contentsCount} file${directoryEntity.contentsCount == 1 ? 's' : ''}",
      ),
      onTap: onTap,
      onLongPress: onLongPress,
      enabled: enabled,
      selected: selected,
      trailing: selected ? Icon(Icons.check) : null,
    );
  }
}
