sealed class PickerResult {
  const PickerResult();
}

sealed class FilePickerResult extends PickerResult {
  const FilePickerResult();
}

sealed class DirectoryPickerResult extends PickerResult {
  const DirectoryPickerResult();
}

class SingleFilePickerResult extends FilePickerResult {
  final String filePath;
  const SingleFilePickerResult({required this.filePath});
}

class MutlipleFilePickerResult extends FilePickerResult {
  final List<String> filePaths;
  const MutlipleFilePickerResult({required this.filePaths});
}

class SingleDirectoryPickerResult extends DirectoryPickerResult {
  final String directoryPath;
  const SingleDirectoryPickerResult({required this.directoryPath});
}

class MultipleDirectoryPickerResult extends DirectoryPickerResult {
  final List<String> directoryPaths;
  const MultipleDirectoryPickerResult({required this.directoryPaths});
}
