sealed class PickerConfig {
  final String? initialPath;
  const PickerConfig({this.initialPath});
}

sealed class FilePickerConfig extends PickerConfig {
  final List<String>? allowedExtensions;
  const FilePickerConfig({super.initialPath, this.allowedExtensions});
}

sealed class DirectoryPickerConfig extends PickerConfig {
  const DirectoryPickerConfig({super.initialPath});
}

class SingleFilePickerConfig extends FilePickerConfig {
  const SingleFilePickerConfig({super.initialPath, super.allowedExtensions});
}

class MultipleFilePickerConfig extends FilePickerConfig {
  final int minFiles;
  final int? maxFiles;
  MultipleFilePickerConfig({
    super.initialPath,
    super.allowedExtensions,
    this.minFiles = 0,
    this.maxFiles,
  }) {
    assert(minFiles >= 0, "Invalid minFiles");
    assert(maxFiles == null || maxFiles! >= 1, "Invalid maxFiles");
    assert(
      maxFiles == null || minFiles <= maxFiles!,
      "minFiles cannot be greater than maxFiles",
    );
  }
}

class SingleDirectoryPickerConfig extends DirectoryPickerConfig {
  const SingleDirectoryPickerConfig({super.initialPath});
}

class MultipleDirectoryPickerConfig extends DirectoryPickerConfig {
  final int minDirectories;
  final int? maxDirectories;
  MultipleDirectoryPickerConfig({
    super.initialPath,
    this.minDirectories = 0,
    this.maxDirectories,
  }) {
    assert(minDirectories >= 0, "Invalid minDirectories");
    assert(
      maxDirectories == null || maxDirectories! >= 1,
      "Invalid maxDirectories",
    );
    assert(
      maxDirectories == null || minDirectories <= maxDirectories!,
      "minDirectories cannot be greater than maxDirectories",
    );
  }
}
