import 'dart:io';
import 'package:io_file_picker_ui/src/fs_entities.dart';
import 'package:path/path.dart' as p;

extension BaseName on FileSystemEntity {
  String get name {
    return p.basename(path);
  }
}

extension FileExtension on File {
  String get fileExtension {
    return p.extension(path);
  }
}

extension GetFileTypeFromFileName on File {
  Future<FileType> getFileTypeFromFileExtension() async {
    final fileExtension = p.extension(path).trim();
    if (fileExtension.isEmpty) {
      return FileType.unknown;
    } else if (_audioFileExtensions.contains(fileExtension)) {
      return FileType.audio;
    } else if (_videoFileExtensions.contains(fileExtension)) {
      return FileType.video;
    } else if (_imageFileExtensions.contains(fileExtension)) {
      return FileType.image;
    } else if (_archiveFileExtensions.contains(fileExtension)) {
      return FileType.archive;
    } else if (_plainTextFileExtension.contains(fileExtension)) {
      return FileType.plainText;
    } else if (_documentFileExtensions.contains(fileExtension)) {
      return FileType.document;
    } else {
      return FileType.unknown;
    }
  }
}

const _audioFileExtensions = {
  ".mp3",
  ".wav",
  ".aac",
  ".ogg",
  ".flac",
  ".wma",
  ".m4a",
};
const _videoFileExtensions = {
  ".mp4",
  ".mkv",
  ".mov",
  ".3gp",
  ".avi",
  "wmv",
  ".webm",
  ".ogv",
  ".m4v",
};
const _imageFileExtensions = {
  ".jpg",
  ".jpeg",
  ".png",
  ".webp",
  ".gif",
  ".raw",
  ".svg",
  ".tiff",
  ".bmp",
};
const _archiveFileExtensions = {
  ".zip",
  ".tar",
  ".tar.gz",
  ".tgz",
  ".tar.bz",
  ".tar.xz",
  ".tar.lz",
  ".rar",
  ".ar",
  ".7z",
  ".bz2",
  ".gz",
  ".xz",
};
const _plainTextFileExtension = {".txt", ".md", ".log"};

const _documentFileExtensions = {
  ".doc",
  ".docx",
  ".odt",
  ".rtf",
  ".pdf",
  ".xls",
  ".xlsx",
  ".ods",
  ".csv",
  ".tsv",
  ".ppt",
  ".pptx",
  ".odp",
  ".",
};
