import 'package:flutter/material.dart';
import 'package:io_file_picker_ui/src/io_file_picker_ui_widget.dart';
import 'package:io_file_picker_ui/src/picker_config.dart';
import 'package:io_file_picker_ui/src/picker_result.dart';

export 'src/barrel.dart';

Future<PickerResult?> showIoFilePicker(
  BuildContext context, {
  PickerConfig pickerConfig = const SingleFilePickerConfig(),
  String? dialogTitle,
}) async {
  return showGeneralDialog(
    context: context,
    fullscreenDialog: true,
    barrierDismissible: false,
    pageBuilder: (context, animation, secondaryAnimation) {
      return SafeArea(
          child: IoFilePickerUi(
        pickerConfig: pickerConfig,
        dialogTitle: dialogTitle,
      ));
    },
  );
}
