import 'package:flutter/material.dart';
import 'package:io_file_picker_ui/io_file_picker_ui.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});
  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Flutter Demo',
      theme: ThemeData(colorScheme: .fromSeed(seedColor: Colors.deepPurple)),
      darkTheme: ThemeData(
        colorScheme: .fromSeed(
          seedColor: Colors.deepPurple,
          brightness: Brightness.dark,
        ),
      ),
      themeMode: ThemeMode.system,
      home: const MyHomePage(title: 'Flutter Demo Home Page'),
    );
  }
}

class MyHomePage extends StatefulWidget {
  const MyHomePage({super.key, required this.title});

  final String title;

  @override
  State<MyHomePage> createState() => _MyHomePageState();
}

class _MyHomePageState extends State<MyHomePage> {
  String output = "";
  final TextEditingController _extensionController = TextEditingController(
    text: ".jpg .png",
  );
  RangeValues rangeValues = RangeValues(0, 10);
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(),
      body: Center(
        child: SingleChildScrollView(
          child: Padding(
            padding: const EdgeInsets.all(8.0),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              mainAxisAlignment: MainAxisAlignment.center,
              spacing: 20,
              children: [
                Row(
                  mainAxisSize: MainAxisSize.max,
                  spacing: 8,
                  children: [
                    Text("Min and max files/directories to select"),
                    Expanded(
                      child: RangeSlider(
                        values: rangeValues,
                        min: 0,
                        max: 10,
                        onChanged: (value) {
                          setState(() {
                            rangeValues = value;
                          });
                        },
                        divisions: 10,
                        labels: RangeLabels(
                          rangeValues.start.toInt().toString(),
                          rangeValues.end.toInt().toString(),
                        ),
                      ),
                    ),
                  ],
                ),
                Row(
                  mainAxisSize: MainAxisSize.max,
                  spacing: 8,
                  children: [
                    Text("Allowed extensions (delimited by space)"),
                    Expanded(
                      child: TextFormField(
                        controller: _extensionController,
                        decoration: InputDecoration(
                          border: OutlineInputBorder(),
                        ),
                      ),
                    ),
                  ],
                ),
                OutlinedButton(
                  onPressed: () async {
                    final fileResult = await showIoFilePicker(
                      context,
                      pickerConfig: SingleFilePickerConfig(
                        allowedExtensions:
                            (_extensionController.text.trim().isNotEmpty)
                            ? _extensionController.text
                                  .trim()
                                  .split(" ")
                                  .toList()
                            : null,
                      ),
                    );
                    if (fileResult case SingleFilePickerResult(
                      :final filePath,
                    )) {
                      setState(() {
                        output = filePath;
                      });
                    } else {
                      setState(() {
                        output = "No file selected";
                      });
                    }
                  },
                  child: Text("Select single file"),
                ),
                OutlinedButton(
                  onPressed: () async {
                    final fileResult = await showIoFilePicker(
                      context,
                      pickerConfig: SingleDirectoryPickerConfig(),
                    );
                    if (fileResult case SingleDirectoryPickerResult(
                      :final directoryPath,
                    )) {
                      setState(() {
                        output = directoryPath;
                      });
                    } else {
                      setState(() {
                        output = "No directory selected";
                      });
                    }
                  },
                  child: Text("Select single directory"),
                ),
                OutlinedButton(
                  onPressed: () async {
                    final fileResult = await showIoFilePicker(
                      context,
                      pickerConfig: MultipleFilePickerConfig(
                        minFiles: rangeValues.start.toInt(),
                        maxFiles: rangeValues.end.toInt(),
                        allowedExtensions:
                            (_extensionController.text.trim().isNotEmpty)
                            ? _extensionController.text
                                  .trim()
                                  .split(" ")
                                  .toList()
                            : null,
                      ),
                    );
                    if (fileResult case MutlipleFilePickerResult(
                      :final filePaths,
                    ) when filePaths.isNotEmpty) {
                      setState(() {
                        output = filePaths.reduce(
                          (value, element) => "$value\n$element",
                        );
                      });
                    } else {
                      setState(() {
                        output = "No files selected";
                      });
                    }
                  },
                  child: Text("Select mutliple files"),
                ),
                OutlinedButton(
                  onPressed: () async {
                    final fileResult = await showIoFilePicker(
                      context,
                      pickerConfig: MultipleDirectoryPickerConfig(
                        minDirectories: rangeValues.start.toInt(),
                        maxDirectories: rangeValues.end.toInt(),
                      ),
                    );
                    if (fileResult case MultipleDirectoryPickerResult(
                      :final directoryPaths,
                    ) when directoryPaths.isNotEmpty) {
                      setState(() {
                        output = directoryPaths.reduce(
                          (value, element) => "$value\n$element",
                        );
                      });
                    } else {
                      setState(() {
                        output = "No directories selected";
                      });
                    }
                  },
                  child: Text("Select multiple directories"),
                ),
                Text("Selected:\n$output", textAlign: TextAlign.center),
              ],
            ),
          ),
        ),
      ),
    );
  }
}
