import csv
import os
import tools
from regionManager import RegionManager
from regionManagerFactory import RegionManagerFactory

# Étape 0 : Détermination du séparateur
separator = ','
print("Séparateur utilisé : " + separator)
dialect = csv.unix_dialect
dialect.delimiter = separator

def extraireWikidataIdentifiant(url):
    partsUrl = url.split("/")
    return partsUrl[-1]

# On charge les informations de la région
config = {
    "prefixIdExterne": "SNCF",
    "lignesType": "Train",
    "importType": {
        "lignes": False
    }
}
regionId = "CentreVdL"
regionManagerFactory = RegionManagerFactory(config, 187)
regionMgt = regionManagerFactory.getRegionManager(regionId, "Centre-Val de Loire")
fRegionInfos = regionMgt.getFichierRegion()
prefixeLignes = "Wikidata"
regionsLimitrophes = [
    ["AuvergneRA", "Auvergne-Rhône-Alpes"],
    ["NAquitaine", "Nouvelle-Aquitaine"],
    ["Paris", "Île-de-France"],
    ["Normandie", "Normandie"],
    ["PaysLoire", "Pays de la Loire"],
    ["BourgogneFC", "Bourgogne-Franche-Comté"]
]

listeGaresNonTrouve = []
encodingFile = "utf8"
posCol = {}
with open("data.csv", 'r+', encoding=encodingFile) as fichierData:
    fData = csv.reader(fichierData, dialect)

    # Étape 2 : On récupère ses entêtes
    titre = next(fData)
    posCol = tools.getEntetesList(titre)
    print('Liste des entêtes : ')
    print(posCol)

    for contenu in fData:
        #print(contenu)
        idLigne = extraireWikidataIdentifiant(contenu[posCol["ligne"]])
        ligneLabel = contenu[posCol["ligneLabel"]]
        stationLabel = contenu[posCol["stationLabel"]]
        stationAltLabel = contenu[posCol["stationAltLabel"]]
        # print("Ligne " + idLigne + " : " + ligneLabel)
        # print("Station " + extraireWikidataIdentifiant(contenu[posCol["station"]]) + " : " + stationLabel)
        # print("------")
        possiblesOrthographesStationLabel = list(map(lambda n: n.lower(), [
            stationLabel, 
            stationLabel.replace("-", " "), 
            stationLabel.replace(" - ", " "), 
            stationLabel.replace(" - ", " ").replace("-", " ")
        ] + stationAltLabel.split(", ")))

        # On doit trouver la station dans la liste des gares existantes
        gareExistante = None
        for idGare in fRegionInfos["garesData"]:
            dataGare = fRegionInfos["garesData"][idGare]
            if dataGare["nom"].lower() in possiblesOrthographesStationLabel:
                gareExistante = dataGare
                break

        if gareExistante == None:
            print("Gare non trouvée " + extraireWikidataIdentifiant(contenu[posCol["station"]]) + " : " + stationLabel)
            listeGaresNonTrouve.append(contenu)
        # print(gareExistante)

        # Et on insert la ligne
        if not gareExistante == None:
            ligne = {
                "id": "Ligne_"+prefixeLignes+"_"+idLigne,
                "nom": ligneLabel
            }

            regionMgt.ajouterLigne(ligne)
            regionMgt.ajouterGareDansLigne(gareExistante, ligne)
    
# Le repéchage va se passer dans les régions limitrophes
print("-------")
print("Repéchage")
for regionLimitrophe in regionsLimitrophes:
    regionLimitropheMgt = regionManagerFactory.getRegionManager(regionLimitrophe[0], regionLimitrophe[1])
    fRegionLimInfos = regionLimitropheMgt.getFichierRegion()
    print("Parcours de la région " + regionLimitrophe[1])
    garesTrouves = []
    for contenu in listeGaresNonTrouve:
        #print(contenu)
        idLigne = extraireWikidataIdentifiant(contenu[posCol["ligne"]])
        ligneLabel = contenu[posCol["ligneLabel"]]
        stationLabel = contenu[posCol["stationLabel"]]
        stationAltLabel = contenu[posCol["stationAltLabel"]]
        print("> Recherche de " + stationLabel)
        # print("Ligne " + idLigne + " : " + ligneLabel)
        # print("Station " + extraireWikidataIdentifiant(contenu[posCol["station"]]) + " : " + stationLabel)
        # print("------")
        possiblesOrthographesStationLabel = list(map(lambda n: n.lower(), [
            stationLabel, 
            stationLabel.replace("-", " "), 
            stationLabel.replace(" - ", " "), 
            stationLabel.replace(" - ", " ").replace("-", " ")
        ] + stationAltLabel.split(", ")))

        # On doit trouver la station dans la liste des gares existantes
        gareExistante = None
        for idGare in fRegionLimInfos["garesData"]:
            dataGare = fRegionLimInfos["garesData"][idGare]

            if dataGare["nom"].lower() in possiblesOrthographesStationLabel:
                gareExistante = dataGare
                break

        if gareExistante == None:
            continue
        # print(gareExistante)
        print("[" + regionLimitrophe[1] + "] Gare repéchée " + extraireWikidataIdentifiant(contenu[posCol["station"]]) + " : " + stationLabel)

        # Et on insert la ligne
        ligne = {
            "id": "Ligne_"+prefixeLignes+"_"+idLigne,
            "nom": ligneLabel
        }

        gareExistante["dossierId"] = regionId
        regionMgt.addGare(gareExistante)
        regionMgt.ajouterLigne(ligne)
        regionMgt.ajouterGareDansLigne(gareExistante, ligne)
        garesTrouves.append(contenu)
    
    for contenu in garesTrouves:
        listeGaresNonTrouve.remove(contenu)

print("Liste des gares absolument pas trouvées :")
for contenu in listeGaresNonTrouve:
    stationLabel = contenu[posCol["stationLabel"]]
    print(extraireWikidataIdentifiant(contenu[posCol["station"]]) + " : " + stationLabel)
regionMgt.save()