import urllib.request
import tools
import os
import json
from regionManager import RegionManager

class tflParser:
  def __init__(self, config, metadonnees):
    self.config = config
    self.metadonnees = metadonnees

  def parse(self):

    opener = urllib.request.build_opener()
    opener.addheaders = [('User-agent', 'Mozilla/5.0')]
    # opener.addheaders = [('Accept', 'application/json')]
    urllib.request.install_opener(opener)

    scriptFolder = os.path.dirname(os.path.realpath(__file__)) + "/"
    dossierId = tools.getValue('dossierId', {}, self.config['default_value'])
    region = dossierId
    regionMgt = RegionManager(self.config, dossierId, region, self.metadonnees)
    fRegionInfos = regionMgt.getFichierRegion()

    #Étape 1 : On commence par récupérer la liste des lignes
    tmpFileName = scriptFolder+'lines.json'
    if os.path.isfile(tmpFileName):
      os.remove(tmpFileName)
    typeLines = self.config["mode"]
    lien = f"https://api.tfl.gov.uk/Line/Mode/{typeLines}/Route"
    tools.telechargerFichier(lien, tmpFileName)

    with open(tmpFileName, 'r') as fichierData:
      data = json.load(fichierData)
      lignes = []
      idLignes = []
      for line in data:
        idLine = line["id"]
        nameLine = line["name"]
        lignes.append({"id": idLine, "nom": nameLine})
        idLignes.append(idLine)
      
    os.remove(tmpFileName)

    for ligne in lignes:
      print(f"> Traitement de la ligne {ligne["nom"]}")

      tmpFileStationName = scriptFolder+'stations.json'
      if os.path.isfile(tmpFileStationName):
        os.remove(tmpFileStationName)
      lien = f"https://api.tfl.gov.uk/Line/{ligne["id"]}/Route/Sequence/all"
      tools.telechargerFichier(lien, tmpFileStationName)

      with open(tmpFileStationName, 'r') as fichierStationData:
        dataStation = json.load(fichierStationData)
        sequenceLigne = dataStation["orderedLineRoutes"][0]["naptanIds"]
        for station in dataStation["stations"]:
          typeStop = station["stopType"]
          if typeStop != "NaptanMetroStation" and typeStop != "NaptanRailStation" and typeStop != "TransportInterchange":
            continue
          idExterne = f"Tfl{station["icsId"]}"
          name = station["name"].replace(" Underground Station", "").replace(" Rail Station", "")
          print(f">> Traitement de la station {name}")
          latitude = station["lat"]
          longitude = station["lon"]
          idInterneStation = station["id"]
          gare = {
            'id': idExterne,
            'idExterne': idExterne,
            'nom': name,
            'longitude': longitude,
            'latitude': latitude
          }

          gare['lignes'] = []
          for linesStation in station["lines"]:
            if not linesStation["id"] in idLignes:
              continue
            sequence = 0
            if linesStation["id"] == ligne["id"]:
              try:
                sequence = sequenceLigne.index(idInterneStation)
              except:
                # print(sequenceLigne)
                sequence = 0
            gare['lignes'].append({'id': "Ligne_"+self.config['prefixIdExterne']+"_"+linesStation["name"], 'nom': linesStation["name"], 'sequence': 0})

          if not gare['idExterne'] in fRegionInfos['idGares']:
            regionMgt.addGare(gare)
          else:
            regionMgt.updateGare(gare)
          
      os.remove(tmpFileStationName)
    
    regionMgt.save()