import urllib.request
import tools
import os
import json
from regionManager import RegionManager

regionSource = "London"
regionToSynchronize = "GreatBritain"

scriptFolder = os.path.dirname(os.path.realpath(__file__)) + "/"
pathSource = f"{scriptFolder}../app/src/main/assets/{regionSource}/Gares.csv"
pathTarget = f"{scriptFolder}../app/src/main/assets/{regionToSynchronize}/Gares.csv"
encoding = "utf8"
gares = {}
with open(pathSource, 'r', encoding=encoding) as fichier:
    entetes = {}
    i = 0
    fichier.seek(0) # On revient au début du fichier
    for ligne in fichier.readlines():
        contenu = ligne.strip().split(';')
        if i == 0:  # entête
            entetes = tools.getEntetes(ligne)
        else:
            gare = {}
            for c, i in entetes.items():
                gare[c] = contenu[i]
            gares[str(gare['id'])] = gare
        i += 1

garesTarget = []
with open(pathTarget, 'r', encoding=encoding) as fichier:
    entetes = {}
    i = 0
    fichier.seek(0) # On revient au début du fichier
    for ligne in fichier.readlines():
        contenu = ligne.strip().split(';')
        if i == 0:  # entête
            entetes = tools.getEntetes(ligne)
        else:
            gare = {}
            for c, i in entetes.items():
                gare[c] = contenu[i]
            if str(gare['id']) in gares:
                gareTarget = gares[str(gare['id'])].copy()
                gareTarget['vCreation'] = gare['vCreation']
                gareTarget['vMaj'] = gare['vMaj']
                gareTarget['vSuppression'] = gare['vSuppression']
                garesTarget.append(gareTarget)
            else:
                garesTarget.append(gare)
        i += 1

with open(pathTarget, 'w', encoding=encoding) as fichier:
    fichier.write(
        "id;idExterne;nom;surTitre;sousTitre;exploitant;latitude;longitude;couleur;couleurEvolution;vCreation;vMaj;vSuppression\n")
    
    for gare in garesTarget:
        fichier.write(gare['id']+';'+gare['idExterne']+';'+tools.nettoyerTexte(gare['nom'])+
                                            ';'+tools.nettoyerTexte(gare['surTitre'])+';'+tools.nettoyerTexte(gare['sousTitre'])+
                                            ';'+gare['exploitant']+';'+str(gare['latitude']) +
                                            ';'+str(gare['longitude'])+';'+str(gare['couleur'])+
                                            ';'+str(gare['couleurEvolution'])+';'+str(gare['vCreation'])+
                                            ';'+str(gare['vMaj'])+';'+str(gare['vSuppression'])+''+"\n")