import csv
import os
import tools
from regionManager import RegionManager
from regionManagerFactory import RegionManagerFactory

versionMetadata = 191
regionGare = "NAquitaine"
encoding = "utf8"
listeGaresFusion = [
    # Gare conservée, suivi des gares à fusionner dedans
    ["SNCF01303", "TBMTSJEAN"], # Gare Bordeaux Saint-Jean
    ["SNCF02446", "TBMTARLAC"], # Mérignac Arlac
    ["SNCF01288", "TBMTPESSA"], # Pessac
    ["SNCF01287", "TBMTPESGAR"], # Pessac Alouette
    ["SNCF01286", "TBMTDORGAT"], # Bègles
    ["SNCF01292", "TBMTCENOG"], # Cenon
    ["SNCF87738096", "TBMTGERMA"], # Le Bouscat - Saint-Germaine
    ["SNCF01289", "TBMTBRUGAR"], # Bruges
    ["SNCF01290", "TBMTGABLAN"], # Blanquefort
    ["TBMTHDVA", "TBMTHDVB"], # Hôtel de ville
    ["TBMTAUBI1C", "TBMTAUBI2C"], # Les Aubiers
]
scriptFolder = os.path.dirname(os.path.realpath(__file__)) + "/"
regionPath = scriptFolder + '../app/src/main/assets/'+regionGare+'/'
separator = ';'
print("Séparateur utilisé : " + separator)

# Lecture de toutes les lignes
with open(regionPath+'Gares.csv', 'r', encoding=encoding) as f:
    gares = f.readlines()

posColGares = tools.getEntetes(gares[0], None, separator)
print('Liste des entêtes : ')
print(posColGares)

nouvellesCoordonnees = []
def gares_a_modifier(g):
    cellules = [s.strip() for s in g.split(separator)]
    if len(cellules) != len(posColGares) or int(cellules[posColGares["vSuppression"]]) > 0:
        return g
    
    for gareFusion in listeGaresFusion:
        if cellules[posColGares["id"]] == gareFusion[0]:
            cellules[posColGares["vMaj"]] = str(versionMetadata)
            return separator.join(cellules) + "\n"

        if cellules[posColGares["id"]] in gareFusion[1:]:
            cellules[posColGares["vCreation"]] = "0"
            cellules[posColGares["vMaj"]] = "0"
            cellules[posColGares["vSuppression"]] = str(versionMetadata)
            nouvellesCoordonnees.append(separator.join([
                gareFusion[0],
                cellules[posColGares["latitude"]],
                cellules[posColGares["longitude"]]
            ]) + "\n")
            return separator.join(cellules) + "\n"

    return g

# On lit le fichier des gares
garesModifiees = [gares_a_modifier(g) for g in gares[1:]]

# Réécriture dans le même fichier
with open(regionPath+'Gares.csv', "w", encoding="utf-8") as f:
    f.writelines([gares[0]] + garesModifiees)

# Maintenant, on s'occupe des relations
with open(regionPath+'GaresDansLigne.csv', 'r', encoding=encoding) as f:
    relations = f.readlines()

posColRelations = tools.getEntetes(relations[0], None, separator)
print('Liste des entêtes : ')
print(posColRelations)

relationsSupplementaires = []
def relations_a_modifier(r):
    cellules = [s.strip() for s in r.split(separator)]
    if len(cellules) != len(posColRelations) or int(cellules[posColRelations["vSuppression"]]) > 0:
        return r
    
    for gareFusion in listeGaresFusion:
        if cellules[posColRelations["idGare"]] in gareFusion[1:]:
            cellules[posColRelations["vCreation"]] = "0"
            cellules[posColRelations["vMaj"]] = "0"
            cellules[posColRelations["vSuppression"]] = str(versionMetadata)

            nouvelleRelation = cellules.copy()
            nouvelleRelation[posColRelations["idGare"]] = gareFusion[0]
            nouvelleRelation[posColRelations["vCreation"]] = str(versionMetadata)
            nouvelleRelation[posColRelations["vMaj"]] = "0"
            nouvelleRelation[posColRelations["vSuppression"]] = "0"
            relationsSupplementaires.append(separator.join(nouvelleRelation) + "\n")

            return separator.join(cellules) + "\n"

    return r

# On lit le fichier des gares
relationsModifiees = [relations_a_modifier(r) for r in relations[1:]]

# Réécriture dans le même fichier
with open(regionPath+'GaresDansLigne.csv', "w", encoding="utf-8") as f:
    f.writelines([relations[0]] + relationsModifiees + relationsSupplementaires)

# Enfin, on ajoute les relations en plus
with open(regionPath+'Coordonnees.csv', "a", encoding="utf-8") as f:
    f.writelines(nouvellesCoordonnees)
