import csv
import os
import tools
from regionManager import RegionManager
from regionManagerFactory import RegionManagerFactory

versionMetadata = 187
regionGare = "GrandEst"
encoding = "utf8"
idLigneUnique = 'SNCF_' + regionGare + "_U"
scriptFolder = os.path.dirname(os.path.realpath(__file__)) + "/"
regionPath = scriptFolder + '../app/src/main/assets/'+regionGare+'/'
separator = ';'

garesAFermees = [
"SNCF02738",
"SNCF02736",
"SNCF02733",
"SNCF02826",
"SNCF02731",
"SNCF02686",
"SNCF02682",
"SNCF02679",
"SNCF02596",
"SNCF02568",
"SNCF02967",
"SNCF02948",
"SNCF02931",
"SNCF02929",
"SNCF02919",
"SNCF02903",
"SNCF02851",
"SNCF02827"
]

def modifier_gare(ligne):
    cellules = ligne.split(separator)
    if cellules[0] in garesAFermees:
        cellules[-3] = "0"
        cellules[-2] = "0"
        cellules[-1] = str(versionMetadata)
        return separator.join(cellules) + "\n"
    
    return ligne

with open(regionPath+'Gares.csv', 'r', encoding=encoding) as f:
    gares = f.readlines()

gareModif = [modifier_gare(g) for g in gares]

with open(regionPath+'Gares.csv', "w", encoding="utf-8") as f:
    f.writelines(gareModif)

with open(regionPath+'GaresDansLigne.csv', 'r', encoding=encoding) as f:
    gdl = f.readlines()

gdlModif = [modifier_gare(g) for g in gdl]

with open(regionPath+'GaresDansLigne.csv', "w", encoding="utf-8") as f:
    f.writelines(gdlModif)
