import csv
import os
import tools
from regionManager import RegionManager
from regionManagerFactory import RegionManagerFactory

versionMetadata = 195
regionGare = "Espana"
encoding = "utf8"
idLigneUnique = "Renfe_Espana_U"
scriptFolder = os.path.dirname(os.path.realpath(__file__)) + "/"
regionPath = scriptFolder + '../app/src/main/assets/'+regionGare+'/'
associations = {}
with open(regionPath+'GaresDansLigne.csv', 'r', encoding=encoding) as fichier:
    separator = ';'
    print("Séparateur utilisé : " + separator)
    dialect = csv.unix_dialect
    dialect.delimiter = separator
    fData = csv.reader(fichier, dialect)

    titre = next(fData)
    posCol = tools.getEntetesList(titre)
    print('Liste des entêtes : ')
    print(posCol)

    for relation in fData:
        idGare = relation[posCol['idGare']]
        idLigne = relation[posCol['idLigne']]
        vSuppression = relation[posCol['vSuppression']]

        if int(vSuppression) > 0:
            continue

        if not idLigne in associations:
            associations[idLigne] = []
        
        associations[idLigne].append(idGare)
    
# On va chercher pour toute gare dans la ligne unique, celles qui ne sont pas dans d'autres lignes
garesOrphelines = []
relationASupprimer = []
for gareInLigneUnique in associations[idLigneUnique]:
    gareTrouvee = False
    for idLigne in associations:
        if idLigne == idLigneUnique:
            continue
        relations = associations[idLigne]
        for idGare in relations:
            if idGare == gareInLigneUnique:
                gareTrouvee = True
                break
        
        if gareTrouvee:
            break
    
    if not gareTrouvee:
        garesOrphelines.append(gareInLigneUnique)
    else:
        # On va supprimer de la ligne unique
        relationASupprimer.append([gareInLigneUnique, idLigneUnique])

garesOrphelinesLignes = []
with open(regionPath+'Gares.csv', 'r', encoding=encoding) as f:
    gares = f.readlines()
    estEntete = True
    posSuppression = None
    for g in gares:
        cellules = g.split(separator)
        if estEntete:
            for i, c in enumerate(cellules):
                if c.strip() == 'vSuppression':
                    posSuppression = i
            estEntete = False
        else:
            if cellules[0] in garesOrphelines:
                vSuppression = cellules[posSuppression]
                if int(vSuppression) > 0:
                    # La gare est supprimée, on supprime sa relation
                    relationASupprimer.append([cellules[0], idLigneUnique])
                else:
                    garesOrphelinesLignes.append(g)

print("Gares orphelines")
print("".join(garesOrphelinesLignes))

def modifier_ligne(ligne):
    cellules = ligne.split(separator)
    for relation in relationASupprimer:
        if relation[0] == cellules[0] and relation[1] == cellules[1]:
            cellules[-3] = "0"
            cellules[-2] = "0"
            cellules[-1] = str(versionMetadata)
            return separator.join(cellules) + "\n"
    
    return ligne

# Lecture de toutes les lignes
with open(regionPath+'GaresDansLigne.csv', 'r', encoding=encoding) as f:
    lignes = f.readlines()

# Modification des lignes
lignes_modifiees = [modifier_ligne(l) for l in lignes]

# Réécriture dans le même fichier
with open(regionPath+'GaresDansLigne.csv', "w", encoding="utf-8") as f:
    f.writelines(lignes_modifiees)