package fr.nocle.passegares.outils

import fr.nocle.passegares.bdd.InventaireBDD
import org.junit.Assert
import org.junit.Test

/**
 * Created by jonathanmm on 19/02/17.
 */
class CouleurOutilsTest {
    @Test
    fun getHexa_rouge_formattageCorrect() {
        Assert.assertEquals("#f44336", CouleurOutils.getHexa(InventaireBDD.MONNAIE_ROUGE))
    }

    @Test
    fun getHexa_cyan_formattageCorrect() {
        Assert.assertEquals("#00bcd4", CouleurOutils.getHexa(InventaireBDD.MONNAIE_CYAN))
    }

    @Test
    fun getHexa_jaune_formattageCorrect() {
        Assert.assertEquals("#ffeb3b", CouleurOutils.getHexa(InventaireBDD.MONNAIE_JAUNE))
    }

    @Test
    fun getHexa_lime_formattageCorrect() {
        Assert.assertEquals("#cddc39", CouleurOutils.getHexa(InventaireBDD.MONNAIE_LIME))
    }

    @Test
    fun getHexa_marron_formattageCorrect() {
        Assert.assertEquals("#795548", CouleurOutils.getHexa(InventaireBDD.MONNAIE_MARRON))
    }

    @Test
    fun getHexa_orange_formattageCorrect() {
        Assert.assertEquals("#ff9800", CouleurOutils.getHexa(InventaireBDD.MONNAIE_ORANGE))
    }

    @Test
    fun getHexa_vert_formattageCorrect() {
        Assert.assertEquals("#4caf50", CouleurOutils.getHexa(InventaireBDD.MONNAIE_VERT))
    }

    @Test
    fun getHexa_violet_formattageCorrect() {
        Assert.assertEquals("#9c27b0", CouleurOutils.getHexa(InventaireBDD.MONNAIE_VIOLET))
    }

    @Test
    fun getHexa_autre_formattageCorrect() {
        Assert.assertEquals("#f44336", CouleurOutils.getHexa(-1))
    }
}