package fr.nocle.passegares.visa;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import android.app.ActionBar;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;

import fr.nocle.passegares.R;
import fr.nocle.passegares.interfaces.OnNavigateIntentManager;
import fr.nocle.passegares.interfaces.ToolbarManager;
import fr.nocle.passegares.outils.UserInterfaceOutils;

public class VisaActivity extends AppCompatActivity
    implements ToolbarManager,
        OnNavigateIntentManager {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q &&
                Build.VERSION.SDK_INT < Build.VERSION_CODES.VANILLA_ICE_CREAM)
        {
            WindowCompat.enableEdgeToEdge(getWindow());
        }
        setContentView(R.layout.activity_fragment);

        Intent i = getIntent();
        boolean uniquementDuJour = i.getBooleanExtra(ResumeVisaFragment.ARG_DUJOUR, false);
        long idLigne = i.getLongExtra(ResumeVisaFragment.ARG_IDLIGNE, 0);
        Bundle b = new Bundle();
        b.putBoolean(ResumeVisaFragment.ARG_DUJOUR, uniquementDuJour);
        b.putLong(ResumeVisaFragment.ARG_IDLIGNE, idLigne);

        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        ActionBar actionBar = getActionBar();
        if(actionBar != null)
        {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }

        View contenu = findViewById(R.id.fragment_main_frame_layout);
        UserInterfaceOutils.gererBordABord(toolbar, contenu);

        FragmentManager fragmentManager = getSupportFragmentManager();
        Fragment fragment = new VisaFragment();
        fragment.setArguments(b);
        FragmentTransaction transaction = fragmentManager.beginTransaction()
                .replace(R.id.fragment_main_frame_layout, fragment);
        transaction.commit();
    }

    @Override
    public void setTitleToolbar(int ressource) {
        this.setTitle(ressource);
    }

    @Override
    public void setTitleToolbar(String title) {
        this.setTitle(title);
    }

    @Override
    public boolean onMoveActivity(Class activityClass) {
        Intent i = new Intent(this, activityClass);
        startActivity(i);
        return true;
    }

    @Override
    public boolean onMoveActivity(Class activityClass, String name, boolean value) {
        Intent i = new Intent(this, activityClass);
        i.putExtra(name, value);
        startActivity(i);
        return true;
    }

    @Override
    public boolean onMoveActivity(Class activityClass, String name, int value) {
        Intent i = new Intent(this, activityClass);
        i.putExtra(name, value);
        startActivity(i);
        return true;
    }

    @Override
    public boolean onMoveActivity(Class activityClass, String name1, int value1, String name2, boolean value2) {
        Intent i = new Intent(this, activityClass);
        i.putExtra(name1, value1);
        i.putExtra(name2, value2);
        startActivity(i);
        return true;
    }

    @Override
    public boolean getBooleanExtra(String name, boolean defaultValue) {
        return getIntent().getBooleanExtra(name, defaultValue);
    }
}
