package fr.nocle.passegares.visa;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;

import java.util.ArrayList;
import java.util.Objects;

import fr.nocle.passegares.modele.GareTamponnee;
import fr.nocle.passegares.R;
import fr.nocle.passegares.modele.Ligne;
import fr.nocle.passegares.outils.CouleurOutils;
import fr.nocle.passegares.outils.StringOutils;

/**
 * Created by jonathanmm on 03/09/16.
 */
public class TamponsAdapter extends ArrayAdapter<GareTamponnee> {
    private Ligne ligne;
    private boolean afficherFournit;
    private boolean afficherNecessite;
    private boolean afficherNiveau;

    public TamponsAdapter(Context context, ArrayList<GareTamponnee> liste, Ligne l)
    {
        super(context, 0, liste);
        this.ligne = l;
    }

    @NonNull
    @Override
    public View getView(int position, View convertView, @NonNull ViewGroup parent)
    {
        GareTamponnee t = getItem(position);
        // Check if an existing view is being reused, otherwise inflate the view
        if (convertView == null) {
            convertView = LayoutInflater.from(getContext()).inflate(R.layout.tampon_viewer, parent, false);
        }

        TextView champ;
        String nomGare = t.getNomGare();
        champ = (TextView) convertView.findViewById(R.id.nom_gare);
        champ.setText(StringOutils.displayBeautifullNameStation(nomGare));
        if(t.getNbValidations() == 0)
            champ.setTextColor(Color.GRAY);
        else
            champ.setTextColor(Color.BLACK);
        champ = (TextView) convertView.findViewById(R.id.nb_validations);
        champ.setText(String.valueOf(t.getNbValidations()));
        champ = (TextView) convertView.findViewById(R.id.date_tampon);
        if(StringOutils.getRelativeDate(getContext(), t.getDateDerniereValidation()).equals(""))
            champ.setText(null); //Pas encore validé, on laisse vide
        else
        {
            if(afficherNiveau)
                champ.setText(getContext().getString(R.string.niveau) + " " + t.getNiveau());
            else
                champ.setText(getContext().getString(R.string.derniereValidation) + " " + StringOutils.getRelativeDate(getContext(), t.getDateDerniereValidation()));
        }

        //Couleur des tickets
        TextView zoneCouleurFournit = (TextView) convertView.findViewById(R.id.couleurFournit);
        if(t.getNiveau() >= 1 && afficherFournit) {
            int color = Color.parseColor(CouleurOutils.getHexa(t.getCouleur()));
            zoneCouleurFournit.setBackgroundColor(color);
            zoneCouleurFournit.setVisibility(View.VISIBLE);
        } else
        {
            zoneCouleurFournit.setVisibility(View.INVISIBLE);
        }

        TextView zoneCouleurNecessite = (TextView) convertView.findViewById(R.id.couleurNecessite);
        if(t.getNiveau() >= 1 && afficherNecessite)
        {
            int color = Color.parseColor(CouleurOutils.getHexa(t.getCouleurEvolution()));
            zoneCouleurNecessite.setBackgroundColor(color);
            zoneCouleurNecessite.setVisibility(View.VISIBLE);
        } else { //On masque
            zoneCouleurNecessite.setVisibility(View.INVISIBLE);
        }

        //Plan de ligne
        ImageView pdlFond = (ImageView) convertView.findViewById(R.id.planLigneFond);
        ImageView pdlPoint = (ImageView) convertView.findViewById(R.id.planLignePoint);
        if(t.getPlanDeLigneFond() != 0)
        {
            //On va récupérer la couleur
            String couleurHexa = "#000000";

            if(ligne != null && ligne.getCouleur() != null && !Objects.equals(ligne.getCouleur(), ""))
                couleurHexa = ligne.getCouleur();

            int color = Color.parseColor(couleurHexa);

            int valueAlpha;
            if(t.getNbValidations() == 0)
                valueAlpha = 55;
            else
                valueAlpha = 255;

            Integer fond = PlanDeLigneDisplayer.Companion.getFond(t.getPlanDeLigneFond());

            if(fond == null)
            {
                pdlFond.setVisibility(View.GONE);
            } else {
                pdlFond.setImageAlpha(valueAlpha);
                pdlFond.setVisibility(View.VISIBLE);
                pdlFond.setColorFilter(color);
                pdlFond.setImageResource(fond);
            }

            Integer point = PlanDeLigneDisplayer.Companion.getPoint(t.getPlanDeLignePoint());

            if(point == null)
            {
                pdlPoint.setVisibility(View.GONE);
            } else {
                pdlPoint.setImageAlpha(valueAlpha);
                pdlPoint.setVisibility(View.VISIBLE);
                pdlPoint.setColorFilter(color);
                pdlPoint.setImageResource(point);
            }
        } else
        {
            pdlFond.setVisibility(View.GONE);
            pdlPoint.setVisibility(View.GONE);
        }

        return convertView;
    }

    public void setAfficherFournit(boolean afficherFournit) {
        this.afficherFournit = afficherFournit;
    }

    public boolean isAfficherFournit() {
        return afficherFournit;
    }

    public void setAfficherNecessite(boolean afficherNecessite) {
        this.afficherNecessite = afficherNecessite;
    }

    public boolean isAfficherNecessite() {
        return afficherNecessite;
    }

    public void setAfficherNiveau(boolean afficherNiveau) {
        this.afficherNiveau = afficherNiveau;
    }

    public boolean isAfficherNiveau() {
        return afficherNiveau;
    }
}