package fr.nocle.passegares.visa

import android.view.View
import fr.nocle.passegares.R
import fr.nocle.passegares.modele.GareTamponnee

class PlanDeLigneDisplayer {
    companion object {
        /**
         * Get the fond de ligne to use
         * @param plf Number of fond de ligne
         * @return The drawable to use, or null if not exist
         */
        fun getFond(plf: Int): Int? {
            return when (plf) {
                GareTamponnee.LIGNE_SEUL_CENTRE -> R.drawable.plf_01
                GareTamponnee.LIGNE_SEUL_GAUCHE -> R.drawable.plf_02
                GareTamponnee.LIGNE_SEUL_DROITE -> R.drawable.plf_03
                GareTamponnee.LIGNE_SEUL_BRANCHE -> R.drawable.plf_04
                GareTamponnee.LIGNE_SEUL_CENTRE_SP_DROITE -> R.drawable.plf_05
                GareTamponnee.LIGNE_CENTRE_SEUL -> R.drawable.plf_10
                GareTamponnee.LIGNE_CENTRE_CENTRE -> R.drawable.plf_11
                GareTamponnee.LIGNE_CENTRE_GAUCHE -> R.drawable.plf_12
                GareTamponnee.LIGNE_CENTRE_DROITE -> R.drawable.plf_13
                GareTamponnee.LIGNE_CENTRE_BRANCHE -> R.drawable.plf_14
                GareTamponnee.LIGNE_CENTRE_SEUL_SP_DROITE -> R.drawable.plf_15
                GareTamponnee.LIGNE_CENTRE_BRANCHE_SP -> R.drawable.plf_19
                GareTamponnee.LIGNE_GAUCHE_SEUL -> R.drawable.plf_20
                GareTamponnee.LIGNE_GAUCHE_CENTRE -> R.drawable.plf_21
                GareTamponnee.LIGNE_GAUCHE_GAUCHE -> R.drawable.plf_22
                // GareTamponnee.LIGNE_GAUCHE_DROITE -> R.drawable.plf_23
                GareTamponnee.LIGNE_GAUCHE_BRANCHE -> R.drawable.plf_24
                GareTamponnee.LIGNE_GAUCHE_SEUL_SP -> R.drawable.plf_25
                GareTamponnee.LIGNE_GAUCHE_GAUCHE_SP -> R.drawable.plf_27
                GareTamponnee.LIGNE_GAUCHE_DROITE_HAUT_FOURCHE_CENTRE_GAUCHE_BAS -> R.drawable.plf_29
                GareTamponnee.LIGNE_SP_GAUCHE_GAUCHE -> R.drawable.plf_72
                GareTamponnee.LIGNE_SP_GAUCHE_BRANCHE -> R.drawable.plf_74
                GareTamponnee.LIGNE_DROITE_SEUL -> R.drawable.plf_30
                GareTamponnee.LIGNE_DROITE_CENTRE -> R.drawable.plf_31
                // GareTamponnee.LIGNE_DROITE_GAUCHE -> R.drawable.plf_32
                GareTamponnee.LIGNE_DROITE_DROITE -> R.drawable.plf_33
                GareTamponnee.LIGNE_DROITE_BRANCHE -> R.drawable.plf_34
                GareTamponnee.LIGNE_DROITE_BRANCHE_SP -> R.drawable.plf_39
                GareTamponnee.LIGNE_SP_DROITE_BRANCHE -> R.drawable.plf_84
                GareTamponnee.LIGNE_BRANCHE_SEUL -> R.drawable.plf_40
                GareTamponnee.LIGNE_BRANCHE_CENTRE -> R.drawable.plf_41
                GareTamponnee.LIGNE_BRANCHE_GAUCHE -> R.drawable.plf_42
                GareTamponnee.LIGNE_BRANCHE_DROITE -> R.drawable.plf_43
                GareTamponnee.LIGNE_BRANCHE_BRANCHE -> R.drawable.plf_44
                GareTamponnee.LIGNE_BRANCHE_CENTRE_BRANCHE -> R.drawable.plf_45
                GareTamponnee.LIGNE_BRANCHE_BRANCHE_SP_GAUCHE_BAS -> R.drawable.plf_46
                GareTamponnee.LIGNE_BRANCHE_BRANCHE_SP_DROITE_BAS -> R.drawable.plf_47
                GareTamponnee.LIGNE_BRANCHE_DROITE_SP -> R.drawable.plf_48
                GareTamponnee.LIGNE_BRANCHE_BRANCHE_SP -> R.drawable.plf_49
                GareTamponnee.LIGNE_GAUCHE_GAUCHE_CENTRE_GAUCHE -> R.drawable.plf_77
                GareTamponnee.LIGNE_GAUCHE_DROITE_GAUCHE_SP_DROITE_HAUT -> R.drawable.plf_79
                GareTamponnee.LIGNE_SP_BRANCHE_GAUCHE -> R.drawable.plf_92
                GareTamponnee.LIGNE_SP_BRANCHE_DROITE -> R.drawable.plf_93
                GareTamponnee.LIGNE_GAUCHE_DROITE_FOURCHE_GAUCHE_HAUT_GAUCHE_DROITE_BAS -> R.drawable.plf_95
                else -> null
            }
        }

        /**
         * Get the point to use
         * @param pld Number of point
         * @return The drawable to use, or null if not exist
         */
        fun getPoint(pld: Int): Int? {
            return when (pld) {
                GareTamponnee.POINT_CENTRE_DEUX -> R.drawable.pld_01
                GareTamponnee.POINT_CENTRE_BAS -> R.drawable.pld_02
                GareTamponnee.POINT_CENTRE_HAUT -> R.drawable.pld_03
                GareTamponnee.POINT_DROITE_DEUX -> R.drawable.pld_11
                GareTamponnee.POINT_DROITE_BAS -> R.drawable.pld_12
                GareTamponnee.POINT_DROITE_HAUT -> R.drawable.pld_13
                GareTamponnee.POINT_GAUCHE_DEUX -> R.drawable.pld_21
                GareTamponnee.POINT_GAUCHE_BAS -> R.drawable.pld_22
                GareTamponnee.POINT_GAUCHE_HAUT -> R.drawable.pld_23
                else -> null
            }
        }
    }
}