package fr.nocle.passegares.visa

import android.view.View
import fr.nocle.passegares.R

class IndiceLigneDisplayer {
    companion object {
        fun getIcon(idRegion: Long, ville: String?, nomLigne: String): Int? {
            // Normandie
            if (idRegion == 4L) {
                return when (nomLigne) {
                    "Nomad Train" -> R.drawable.il_normandie_ter
                    "Grandes Lignes" -> R.drawable.il_gl
                    else -> null
                }
            }

            // Hauts-de-France
            if (idRegion == 3L) {
                if (ville == null || ville.isEmpty()) {
                    return when (nomLigne) {
                        "TER Hauts-de-France" -> R.drawable.il_hautsdefrance_ter
                        "Grandes Lignes" -> R.drawable.il_gl
                        else -> null
                    }
                }

                return when (ville) {
                    "Lille" -> when(nomLigne) {
                            "Métro 1" -> R.drawable.il_lille_m1
                            "Métro 2" -> R.drawable.il_lille_m2
                            "Tram R" -> R.drawable.il_lille_tr
                            "Tram T" -> R.drawable.il_lille_tt
                            else -> null
                        }
                    else -> null
                }
            }

            // Pays de la Loire
            if (idRegion == 5L) {
                if (ville == null || ville.isEmpty()) {
                    return when (nomLigne) {
                        "Aléop en TER" -> R.drawable.il_paysdelaloire_ter
                        else -> null
                    }
                }

                return when (ville) {
                    "Nantes" -> when(nomLigne) {
                            "Tramway 1" -> R.drawable.il_nantes_t1
                            "Tramway 2" -> R.drawable.il_nantes_t2
                            "Tramway 3" -> R.drawable.il_nantes_t3
                            else -> null
                        }

                    "Le Mans" -> when(nomLigne) {
                            "T1" -> R.drawable.il_lemans_t1
                            "T2" -> R.drawable.il_lemans_t2
                            else -> null
                        }

                    "Angers" -> when(nomLigne) {
                            "Tram A" -> R.drawable.il_angers_trama
                            "Tram B" -> R.drawable.il_angers_tramb
                            "Tram C" -> R.drawable.il_angers_tramc
                            else -> null
                        }
                    else -> null
                }
            }

            // Occitanie
            if (idRegion == 2L) {
                if (ville == null || ville.isEmpty()) {
                    return when (nomLigne) {
                        "lio Train" -> R.drawable.il_occitanie_ter
                        "Grandes Lignes" -> R.drawable.il_gl
                        else -> null
                    }
                }

                return when (ville) {
                    "Toulouse" -> when(nomLigne) {
                            "Métro A" -> R.drawable.il_toulouse_metroa
                            "Métro B" -> R.drawable.il_toulouse_metrob
                            "T1" -> R.drawable.il_toulouse_t1
                            "téléo" -> R.drawable.il_toulouse_teleo
                            else -> null
                        }

                    "Montpellier" -> when(nomLigne) {
                            "T1" -> R.drawable.il_montpellier_t1
                            "T2" -> R.drawable.il_montpellier_t2
                            "T3" -> R.drawable.il_montpellier_t3
                            "T4" -> R.drawable.il_montpellier_t4
                            else -> null
                        }

                    else -> null
                }
            }

            // Nouvelle-Aquitaine
            if (idRegion == 8L) {
                if (ville == null || ville.isEmpty()) {
                    return when (nomLigne) {
                        "TER Nouvelle Aquitaine" -> R.drawable.il_nouvelleaquitaine_ter
                        "Grandes Lignes" -> R.drawable.il_gl
                        else -> null
                    }
                }

                return when (ville) {
                    "Bordeaux" -> when(nomLigne) {
                            "Tram A" -> R.drawable.il_bordeaux_trama
                            "Tram B" -> R.drawable.il_bordeaux_tramb
                            "Tram C" -> R.drawable.il_bordeaux_tramc
                            "Tram D" -> R.drawable.il_bordeaux_tramd
                            else -> null
                        }

                    else -> null
                }
            }

            // Auvergne - Rhône Alpes
            if (idRegion == 11L) {
                if (ville == null || ville.isEmpty()) {
                    return when (nomLigne) {
                        "TER Auvergne Rhône Alpes" -> R.drawable.il_aura_ter
                        else -> null
                    }
                }

                return when (ville) {
                    "Grenoble" -> when(nomLigne) {
                            "Ligne A" -> R.drawable.il_grenoble_trama
                            "Ligne B" -> R.drawable.il_grenoble_tramb
                            "Ligne C" -> R.drawable.il_grenoble_tramc
                            "Ligne D" -> R.drawable.il_grenoble_tramd
                            "Ligne E" -> R.drawable.il_grenoble_trame
                            else -> null
                        }
                    else -> null
                }
            }

            // Bretagne
            if (idRegion == 12L) {
                if (ville == null || ville.isEmpty()) {
                    return when(nomLigne) {
                        "TER BreizhGo" -> R.drawable.il_bretagne_ter
                        else -> null
                    }
                }
                return when (ville) {
                    "Rennes" -> when(nomLigne) {
                            "Métro A" -> R.drawable.il_rennes_metro_a
                            "Métro B" -> R.drawable.il_rennes_metro_b
                            else -> null
                        }

                    "Brest" -> when(nomLigne) {
                            "Ligne A" -> R.drawable.il_brest_tram_a
                            "Ligne C" -> R.drawable.il_brest_telepherique_c
                            else -> null
                        }
                    else -> null
                }
            }

            // Grand Est
            if (idRegion == 9L) {
                return when (ville) {
                    "Nancy" -> when(nomLigne) {
                            "Tempo 1" -> R.drawable.il_nancy_tempo1
                            else -> null
                        }

                    "Mulhouse" -> when(nomLigne) {
                            "1" -> R.drawable.il_mulhouse_tram1
                            "2" -> R.drawable.il_mulhouse_tram2
                            "3" -> R.drawable.il_mulhouse_tram3
                            "tram train" -> R.drawable.il_mulhouse_tramtrain
                            else -> null
                        }

                    else -> null
                }
            }

            // Centre Val de Loire
            if (idRegion == 10L) {
                return when (nomLigne) {
                    "Rémi Centre-Val de Loire" -> R.drawable.il_centrevdl_ter
                    "Grandes Lignes" -> R.drawable.il_gl
                    else -> null
                }
            }

            // Provence Alpes Côte d'Azur
            if (idRegion == 6L) {
                if (ville == null || ville.isEmpty()) {
                    return when(nomLigne) {
                        "TER Zou !" -> R.drawable.il_paca_terzou
                        "Chemins de Fer de Provence" -> R.drawable.il_paca_cheminsferprovence
                        else -> null
                    }
                }

                return when (ville) {
                    "Nice" -> when(nomLigne) {
                            "Tramway 1" -> R.drawable.il_nice_t1
                            "Tramway 2" -> R.drawable.il_nice_t2
                            "Tramway 3" -> R.drawable.il_nice_t3
                            else -> null
                        }

                    "Avignon" -> when(nomLigne) {
                            "T1" -> R.drawable.il_avignon_t1
                            else -> null
                        }
                    
                    else -> null
                }
            }

            // Bourgogne Franche-Comté
            if (idRegion == 7L) {
                if (ville == null || ville.isEmpty()) {
                    return when(nomLigne) {
                        "Mobigo" -> R.drawable.il_bourgognefc_ter
                        else -> null
                    }
                }

                return when (ville) {
                    "Dijon" -> when(nomLigne) {
                            "T1" -> R.drawable.il_dijon_t1
                            "T2" -> R.drawable.il_dijon_t2
                            else -> null
                        }

                    "Besançon" -> when(nomLigne) {
                            "T1" -> R.drawable.il_besancon_t1
                            "T2" -> R.drawable.il_besancon_t2
                            else -> null
                        }

                    else -> null
                }
            }

            // Portugal
            if (idRegion == 16L) {
                return when (ville) {
                    "Porto" -> when (nomLigne) {
                            "A" -> R.drawable.il_porto_metro_a
                            "B" -> R.drawable.il_porto_metro_b
                            "Bx" -> R.drawable.il_porto_metro_bx
                            "C" -> R.drawable.il_porto_metro_c
                            "D" -> R.drawable.il_porto_metro_d
                            "E" -> R.drawable.il_porto_metro_e
                            "F" -> R.drawable.il_porto_metro_f
                            else -> null
                        }
                    else -> null
                }
            }

            // Île-de-France
            if (idRegion == 1L) {
                return when (nomLigne) {
                    "RER A" -> R.drawable.il_paris_rer_a
                    "RER B" -> R.drawable.il_paris_rer_b
                    "RER C" -> R.drawable.il_paris_rer_c
                    "RER D" -> R.drawable.il_paris_rer_d
                    "RER E" -> R.drawable.il_paris_rer_e
                    "Transilien H" -> R.drawable.il_paris_transilien_h
                    "Transilien J" -> R.drawable.il_paris_transilien_j
                    "Transilien K" -> R.drawable.il_paris_transilien_k
                    "Transilien L" -> R.drawable.il_paris_transilien_l
                    "Transilien N" -> R.drawable.il_paris_transilien_n
                    "Transilien P" -> R.drawable.il_paris_transilien_p
                    "Transilien R" -> R.drawable.il_paris_transilien_r
                    "Transilien U" -> R.drawable.il_paris_transilien_u
                    "Transilien V" -> R.drawable.il_paris_transilien_v
                    "Métro 1" -> R.drawable.il_paris_metro_m1
                    "Métro 2" -> R.drawable.il_paris_metro_m2
                    "Métro 3" -> R.drawable.il_paris_metro_m3
                    "Métro 3bis" -> R.drawable.il_paris_metro_m3bis
                    "Métro 4" -> R.drawable.il_paris_metro_m4
                    "Métro 5" -> R.drawable.il_paris_metro_m5
                    "Métro 6" -> R.drawable.il_paris_metro_m6
                    "Métro 7" -> R.drawable.il_paris_metro_m7
                    "Métro 7bis" -> R.drawable.il_paris_metro_m7bis
                    "Métro 8" -> R.drawable.il_paris_metro_m8
                    "Métro 9" -> R.drawable.il_paris_metro_m9
                    "Métro 10" -> R.drawable.il_paris_metro_m10
                    "Métro 11" -> R.drawable.il_paris_metro_m11
                    "Métro 12" -> R.drawable.il_paris_metro_m12
                    "Métro 13" -> R.drawable.il_paris_metro_m13
                    "Métro 14" -> R.drawable.il_paris_metro_m14
                    "Tramway T1" -> R.drawable.il_paris_tram_t1
                    "Tramway T2" -> R.drawable.il_paris_tram_t2
                    "Tramway T3a" -> R.drawable.il_paris_tram_t3a
                    "Tramway T3b" -> R.drawable.il_paris_tram_t3b
                    "Tramway T4" -> R.drawable.il_paris_tram_t4
                    "Tramway T5" -> R.drawable.il_paris_tram_t5
                    "Tramway T6" -> R.drawable.il_paris_tram_t6
                    "Tramway T7" -> R.drawable.il_paris_tram_t7
                    "Tramway T8" -> R.drawable.il_paris_tram_t8
                    "Tramway T9" -> R.drawable.il_paris_tram_t9
                    "Tramway T10" -> R.drawable.il_paris_tram_t10
                    "Tramway T11" -> R.drawable.il_paris_tram_t11
                    "Tramway T12" -> R.drawable.il_paris_tram_t12
                    "Tramway T13" -> R.drawable.il_paris_tram_t13
                    "Tramway T14" -> R.drawable.il_paris_tram_t14
                    "Grandes Lignes" -> R.drawable.il_gl
                    "orlyval" -> R.drawable.il_iledefrance_orlyval
                    "CDGVAL" -> R.drawable.il_iledefrance_cdgval
                    "Funiculaire de Montmartre" -> R.drawable.il_iledefrance_fun
                    else -> null
                }
            }

            // Absolument rien trouvé
            return null
        }
    }
}
