package fr.nocle.passegares.succes;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListView;

import androidx.fragment.app.Fragment;

import java.util.ArrayList;

import fr.nocle.passegares.R;
import fr.nocle.passegares.adapter.CorrespondancesAdapter;
import fr.nocle.passegares.controlleur.GareCtrl;
import fr.nocle.passegares.controlleur.LigneCtrl;
import fr.nocle.passegares.controlleur.TamponCtrl;
import fr.nocle.passegares.interfaces.ToolbarManager;
import fr.nocle.passegares.modele.Ligne;
import fr.nocle.passegares.modele.LigneTamponnee;
import fr.nocle.passegares.visa.ResumeVisaFragment;
import fr.nocle.passegares.visa.VisaActivity;

public class SuccesFragment extends Fragment {
    private SuccesCtrl succesControlleur;
    private ToolbarManager _toolbarManager;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        View view = inflater.inflate(R.layout.activity_succes, null);

        succesControlleur = new SuccesCtrl(getActivity());

        //On récupère la liste des succès
        ArrayList<Succes> listeSucces = succesControlleur.getAllSucces();

        //On récupère la progression
        for(Succes s : listeSucces)
        {
            if(s.isEstAffiche())
            {
                switch(s.getType())
                {
                    case SuccesManager.TypeGare: {
                        if(!s.isEstValide())
                        {
                            GareCtrl gareControlleur = new GareCtrl(getActivity());
                            s.setProgression(gareControlleur.getNbGaresTamponnees());
                            gareControlleur.close();
                        }
                    }
                        break;
                    case SuccesManager.TypeLigne: {
                        if(!s.isEstValide())
                        {
                            LigneCtrl ligneControlleur = new LigneCtrl(getActivity());
                            s.setProgression(ligneControlleur.getNombreLignesCompletees());
                            ligneControlleur.close();
                        }
                    }
                        break;
                    case SuccesManager.TypeValidation: {
                        if(!s.isEstValide())
                        {
                            GareCtrl gareControlleur = new GareCtrl(getActivity());
                            s.setProgression(gareControlleur.getMaxTamponInGare());
                            gareControlleur.close();
                        }
                    }
                        break;
                    case SuccesManager.TypeLigneRegion: {
                        succesControlleur.setProgression(s);
                    }
                        break;
                }
            }
        }

        SuccesAdapter adapter = new SuccesAdapter(getActivity(), listeSucces);
        ListView listeSuccesView = view.findViewById(R.id.listeSucces);
        listeSuccesView.setAdapter(adapter);

        listeSuccesView.setOnItemClickListener((parent, view2, position, id) -> {
            Succes succes = listeSucces.get(position);
            if(succes.getType() != SuccesManager.TypeLigneRegion)
            {
                return;
            }

            final AlertDialog.Builder dialog = new AlertDialog.Builder(getContext());
            dialog.setTitle(R.string.dialogLigneAValiderTitre);

            final Activity mainActivity = getActivity();
            LayoutInflater inflater1 = mainActivity.getLayoutInflater();

            View viewDialog = inflater1.inflate(R.layout.dialog_correspondances_gare, null);

            ListView gridCorrespondance = viewDialog.findViewById(R.id.listeCorrespondance);

            ArrayList<LigneSucces> listeLignes = succes.getListeLignes();
            LigneSuccesAdapter ligneSuccesAdapter = new LigneSuccesAdapter(getContext(), listeLignes);
            gridCorrespondance.setAdapter(ligneSuccesAdapter);

            gridCorrespondance.setOnItemClickListener((parent1, view1, position1, id1) -> {
                Ligne ligne = listeLignes.get(position1).getLigne();
                Intent i = new Intent(mainActivity, VisaActivity.class);
                i.putExtra(ResumeVisaFragment.ARG_IDLIGNE, ligne.getId());
                startActivity(i);
            });

            dialog.setView(viewDialog);
            dialog.create();

            dialog.show();
        });

        return view;
    }

    @TargetApi(Build.VERSION_CODES.M)
    @Override
    public void onAttach(Context context)
    {
        super.onAttach(context);
        initializeManagerAndToolbar();
    }

    @SuppressWarnings("depreciation")
    @Override
    public void onAttach(Activity activity)
    {
        super.onAttach(activity);

        if(Build.VERSION.SDK_INT < Build.VERSION_CODES.M)
        {
            initializeManagerAndToolbar();
        }
    }

    private void initializeManagerAndToolbar() {
        this.createCallbackToolbarManager();

        this.initializeToolbar();
    }

    private void initializeToolbar() {
        _toolbarManager.setTitleToolbar(R.string.voirSucces);
    }

    private void createCallbackToolbarManager() {
        try
        {
            _toolbarManager = (ToolbarManager) getActivity();
        } catch(ClassCastException ex)
        {
            Log.e("Succès", "Problème lors du cast de l'activité : " + ex.getMessage());
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        this.initializeToolbar();
    }
}
