package fr.nocle.passegares.succes;

import static android.view.View.INVISIBLE;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.ArrayList;

import fr.nocle.passegares.R;
import fr.nocle.passegares.modele.Ligne;
import fr.nocle.passegares.visa.IndiceLigneDisplayer;
import fr.nocle.passegares.visa.LigneTamponneeAdapter;

/**
 * Created by jonathanmm on 06/07/17.
 */

public class LigneSuccesAdapter extends ArrayAdapter<LigneSucces> {
    public LigneSuccesAdapter(Context context, ArrayList<LigneSucces> liste)
    {
        super(context, 0, liste);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent)
    {
        LigneSucces ls = getItem(position);

        // Check if an existing view is being reused, otherwise inflate the view
        if (convertView == null) {
            convertView = LayoutInflater.from(getContext()).inflate(R.layout.viewer_correspondance, parent, false);
        }

        if(ls == null)
        {
            return convertView;
        }

        TextView champ;
        Ligne l = ls.getLigne();
        champ = (TextView) convertView.findViewById(R.id.nomLigne);
        LigneTamponneeAdapter.setNomLigne(champ, l.getNom(), l.getRegion());

        champ = (TextView) convertView.findViewById(R.id.sousNomLigne);
        if(l.getSousNom() == null || l.getSousNom().isEmpty())
        {
            champ.setVisibility(View.GONE);
        } else {
            champ.setVisibility(View.VISIBLE);
            champ.setText(l.getSousNom());
        }

        ImageView iconView = (ImageView) convertView.findViewById(R.id.iconeLigne);

        Integer icon = IndiceLigneDisplayer.Companion.getIcon(l.getIdRegion(), l.getVille(), l.getNom());

        if(icon == null)
        {
            iconView.setImageDrawable(null);
            iconView.setVisibility(View.INVISIBLE);
        } else {
            iconView.setImageResource(icon);
            iconView.setVisibility(View.VISIBLE);
        }

        champ = (TextView) convertView.findViewById(R.id.nomRegion);
        String nomRegion = l.getRegion().getNom();

        if(l.getVille() != null && !l.getVille().isEmpty())
        {
            nomRegion += " > " + l.getVille();
        }

        if(nomRegion.isEmpty())
        {
            champ.setVisibility(INVISIBLE);
        } else {
            champ.setText(nomRegion);
        }

        TextView estCompletTexte = (TextView) convertView.findViewById(R.id.succesAtteint);
        estCompletTexte.setVisibility(View.VISIBLE);

        if(ls.getNbGaresTamponnees() == l.getNbGares())
        {
            estCompletTexte.setText(R.string.ligneComplete);
        } else {
            estCompletTexte.setText(
                    String.format(getContext().getString(R.string.progressionSucces),
                    ls.getNbGaresTamponnees(),
                    l.getNbGares()));
        }

        return convertView;
    }
}
