package fr.nocle.passegares.region

import android.content.Context
import android.content.DialogInterface
import fr.nocle.passegares.controlleur.GareCtrl
import fr.nocle.passegares.controlleur.GareDansLigneCtrl
import fr.nocle.passegares.controlleur.LigneCtrl
import fr.nocle.passegares.succes.SuccesCtrl
import androidx.core.database.sqlite.transaction
import fr.nocle.passegares.controlleur.BoutiqueCtrl
import fr.nocle.passegares.controlleur.TamponCtrl

internal class SupprimerRegionThread(
    private val contexte: Context,
    private val loadingDialog: DialogInterface,
    private val region: Region,
) :
    Thread() {
    override fun run() {
        val regionCtrl = RegionCtrl(contexte)
        val bdd = regionCtrl.open()
        val ligneControlleur = LigneCtrl(bdd)
        val gdlControlleur = GareDansLigneCtrl(bdd)
        val succesControlleur = SuccesCtrl(bdd)
        val gareControlleur = GareCtrl(bdd)
        val boutiqueControlleur = BoutiqueCtrl(bdd)
        val tamponControlleur = TamponCtrl(bdd)

        //On utilise une transaction pour que tout passe en même temps
        bdd.transaction {
            // On commence par supprimer les lignes, gare dans lignes et succès associés à la région
            ligneControlleur.deleteByRegion(region)
            gdlControlleur.deleteByRegion(region)
            succesControlleur.deleteByRegion(region)

            // Puis les gares qui n'ont plus de GareDansLigne
            gareControlleur.deleteOrphan()

            // Puis les tampons et les boutiques associées
            boutiqueControlleur.deleteOrphan()
            tamponControlleur.deleteOrphan()

            //Et on met à jour la région !
            region.isEstInstalle = false
            region.favori = 0
            regionCtrl.update(region)

            // On doit également recalculer les succès sur les lignes
            LigneCtrl.updateAllSuccesConcerningLignes(contexte, this)
            GareCtrl.updateAllSuccesConcerningGares(contexte, this)
        }
        regionCtrl.close()

        loadingDialog.dismiss()
    }
}